package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class ConReceivablePlanPayload extends TwCommonPayload implements Serializable {
    /**
     * id列表
     */
    List<Long> ids;

    @ApiModelProperty("备注")
    @ExcelProperty(index = 6)
    private String remark;
    /**
     * 收款号
     */
    @ApiModelProperty("收款号")
    private String receNo;
    /**
     * 收款阶段
     */
    @ApiModelProperty("收款阶段")
    @ExcelProperty(index = 1)
    private String receStage;
    /**
     * 当期收款金额
     */
    @ApiModelProperty("当期收款金额")
    @ExcelProperty(index = 2)
    private BigDecimal receAmt;
    /**
     * 当期收款比例
     */
    @ApiModelProperty("当期收款比例")
    @ExcelProperty(index = 3)
    private BigDecimal receRatio;
    /**
     * 预计收款日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("预计收款日期")
    private LocalDate expectReceDate;
    @ExcelProperty(index = 4)
    private String expectReceDateStr;
    /**
     * 收款状态
     */
    @ApiModelProperty("收款状态")
    private String receStatus;
    /**
     * 预计开票日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("预计开票日期")
    private LocalDate expectInvDate;
    @ExcelProperty(index = 5)
    private String expectInvDateStr;
    /**
     * 开票状态
     */
    @ApiModelProperty("开票状态")
    private String invStatus;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 开票日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("开票日期")
    private LocalDate invDate;
    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    private BigDecimal alreadyInvAmt;
    /**
     * 未开票金额
     */
    @ApiModelProperty("未开票金额")
    private BigDecimal notInvAmt;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal alreadyReceAmt;
    /**
     * 实际收款日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("实际收款日期")
    private LocalDate actualReceDate;
    /**
     * 未收款金额
     */
    @ApiModelProperty("未收款金额")
    private BigDecimal notReceAmt;
    /**
     * 已确认金额
     */
    @ApiModelProperty("已确认金额")
    private BigDecimal confirmedAmt;
    /**
     * 确认收入日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("确认收入日期")
    private LocalDate confirmedAmtDate;
    /**
     * 子合同ID
     */
    @ApiModelProperty("子合同ID")
    private Long saleConId;

    /**
     * 导入警告
     */
    private String importWarn;

    /**
     * 导入错误
     */
    private String imoprtError;

    @ApiModelProperty("客户申请单号")
    private String relApllyNo;
    /** 已收款金额 */
    @ApiModelProperty("已收款金额")
    private BigDecimal actualRecvAmt;

    /** 实际收款日期 */
    @ApiModelProperty("实际收款日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate actualRecvDate;

    private Long receivePlanIdV4;

    /** 开票批次ID*/
    @ApiModelProperty("开票批次ID")
    private Long invBatchId;

    /** 开票批次ID*/
    @ApiModelProperty("实际收款时间标志 如果是true 就置为null 收款解绑的时候需要")
    private Boolean actualReceDateFlag;

}
