package com.elitesland.tw.tw5.api.prd.visit.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 销售拜访任务执行情况签到记录
 *
 * @author duwh
 * @date 2023-03-13
 */
@Getter
@Setter
public class VisitSignRecordQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /** 拜访计划主键 精确 */
    @ApiModelProperty("拜访计划主键")
    @Query
    private Long planId;
    /** 拜访任务主键crm_visit_task.id 精确 */
    @ApiModelProperty("拜访任务主键crm_visit_task.id")
    @Query
    private Long taskId;
    /** 拜访任务执行情况主键crm_visit_task_run.id */
    @ApiModelProperty("拜访任务执行情况主键crm_visit_task_run.id")
    @Query
    private Long taskRunId;
    /** 任务名称（冗余）crm_visit_task.task_name 模糊 */
    @ApiModelProperty("任务名称（冗余）crm_visit_task.task_name")
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /**
     * 类型 ( 签到 IN  签退 OUT )
     */
    @ApiModelProperty("类型 ( 签到 IN  签退 OUT )")
    @Query
    private String type;
    /** 签到坐标（最新） 模糊 */
    @ApiModelProperty("签到坐标（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String locations;
    /** 签到地点（最新） 模糊 */
    @ApiModelProperty("签到地点（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String address;
    /** 签到图片（最新） 模糊 */
    @ApiModelProperty("签到图片（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String fileCodes;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    @Query
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    @Query
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    @Query
    private String ext3;
    /** 签到时间（最新） BETWEEN */
    @ApiModelProperty("签到时间（最新）")
    @Query(type = Query.Type.BETWEEN)
    private List<LocalDateTime> signTime;
}
