package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimItemConfigRefPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimItemConfigRefQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimItemConfigRefVO;

import java.util.List;

/**
 * 报销科目配置与核算项目管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
public interface AccReimItemConfigRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimItemConfigRefVO}>
     */
    PagingVO<AccReimItemConfigRefVO> queryPaging(AccReimItemConfigRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimItemConfigRefVO}>
     */
    List<AccReimItemConfigRefVO> queryListDynamic(AccReimItemConfigRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimItemConfigRefVO}
     */
    AccReimItemConfigRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimItemConfigRefVO}
     */
    AccReimItemConfigRefVO insert(AccReimItemConfigRefPayload payload);

    /**
     * 批量插入
     *
     * @param payloads
     */
    void batchInsert(List<AccReimItemConfigRefPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimItemConfigRefVO}
     */
    AccReimItemConfigRefVO update(AccReimItemConfigRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimItemConfigRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据报销科目配置删除
     *
     * @param reimConfigId
     */
    void delByReimConfigId(Long reimConfigId);

}
