package com.elitesland.tw.tw5.api.prd.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetPayload extends TwCommonPayload implements Serializable {
    /**
     * 费用归属：合同项目、BU项目、商机项目
     */
    @ApiModelProperty("费用归属：合同项目、BU项目、商机项目")
    private String sourceType;
    /**
     * 费用归属ID
     */
    @ApiModelProperty("费用归属ID")
    private Long sourceId;
    /**
     * 费用归属名称
     */
    @ApiModelProperty("费用归属名称")
    private String sourceName;

    @ApiModelProperty("费用归属编号")
    private String sourceCode;

    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;

    @ApiModelProperty("科目模板ID")
    private Long subjectTempId;
    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String budgetName;
    /**
     * 预算状态：新建、审批中、激活（已审批）、关闭
     */
    @ApiModelProperty("预算状态：新建、审批中、激活（已审批）、关闭")
    private String budgetStatus;
    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;
    /**
     * 已使用金额
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmt;

    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;

    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;
    /**
     * 流程名字
     */
    @ApiModelProperty("流程名字")
    private String procInstName;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 是否可选择 0 false 不可选择 1 true 可选择
     */
    @ApiModelProperty("是否可选择 0 false 不可选择 1 true 可选择")
    private Boolean selectFlag;
    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String budgetCode;
    /**
     * 控制类型：刚性、 柔性 、不控制
     */
    @ApiModelProperty("控制类型：刚性、 柔性 、不控制")
    private String controlType;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate budgetStartDate;
    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate budgetEndDate;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 占用金额
     */
    @ApiModelProperty("占用金额")
    private BigDecimal occupyAmt;

    @ApiModelProperty("累计拨付比例")
    private BigDecimal allocatedAppropriation;

    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;

    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;
    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String extVarchar1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String extVarchar2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String extVarchar3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String extVarchar4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String extVarchar5;
    /**
     * 拓展字段6
     */
    @ApiModelProperty("拓展字段6")
    private String extVarchar6;
    /**
     * 拓展字段7
     */
    @ApiModelProperty("拓展字段7")
    private String extVarchar7;
    /**
     * 拓展字段8
     */
    @ApiModelProperty("拓展字段8")
    private String extVarchar8;
    /**
     * 拓展字段9
     */
    @ApiModelProperty("拓展字段9")
    private String extVarchar9;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;
    /**
     * 流程定义的KEY
     */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /**
     * 预算年度
     */
    @ApiModelProperty("预算年度")
    private String finYear;

    /**
     * 预算总金额
     */
    @ApiModelProperty("预算总金额")
    private BigDecimal totalAmt;
    /**
     * 原始预算总金额
     */
    @ApiModelProperty("原始预算总金额")
    private BigDecimal originalTotalAmt;

    /**
     * 规划费用金额
     */
    @ApiModelProperty("规划费用金额")
    private BigDecimal planAmt;
    /**
     * 原始规划费用金额
     */
    @ApiModelProperty("原始规划费用金额")
    private BigDecimal originalPlanAmt;

    /**
     * 当量预算总数
     */
    @ApiModelProperty("规划当量数")
    private BigDecimal planEqva;
    /**
     * 当量预算总金额
     */
    @ApiModelProperty("规划当量数金额")
    private BigDecimal planEqvaAmt;
    /**
     * 原始当量
     */
    @ApiModelProperty("原始规划当量数")
    private BigDecimal originalPlanEqva;
    /**
     * 原始当量金额
     */
    @ApiModelProperty("原始规划当量数金额")
    private BigDecimal originalPlanEqvaAmt;

    /**
     * 预算提交标志
     */
    @ApiModelProperty("预算提交标志")
    private Boolean submitFlag = false;

    /**
     * 科目预算明细
     */
    @ApiModelProperty("科目预算明细")
    private List<BudgetSubjectDetailPayload> subjectDetailPayloads;

//    /**
//     * 活动列表
//     */
//    @ApiModelProperty("活动列表")
//    private List<PmsProjectActivityPayload> activityPayloads;
    /**
     * 活动列表
     */
    @ApiModelProperty("活动列表")
    private List<PmsProjectWbsPayload> wbsPayloadList;

    /**
     * 拨付比例
     */
    @ApiModelProperty("拨付比例")
    private BigDecimal allocatedProportion;


    /**
     * 项目、合同 相关信息
     */
    @ApiModelProperty("pmo资源负责人id")
    private Long pmoResId;
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    @ApiModelProperty("平台合同类型")
    private String platType;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    @ApiModelProperty("工作类型")
    private String workType;
    @ApiModelProperty("合同状态")
    private String contractStatus;
    @ApiModelProperty("总当量（项目侧数据）")
    private BigDecimal totalEqva;
    @ApiModelProperty("费用总预算（项目侧数据）")
    private BigDecimal totalReimbursement;
    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("预算变更类型")
    private String budgetChangeType;

    @ApiModelProperty("初始项目盈亏平衡最大成本")
    private BigDecimal totalCost;
}
