package com.elitesland.tw.tw5.api.prd.budget.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预算科目明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetSubjectDetailQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 预算ID 精确
     */
    @ApiModelProperty("预算ID")
    private Long budgetId;
    /**
     * 预算ID 精确
     */
    @ApiModelProperty("预算ID")
    private List<Long> budgetIds;
    /**
     * 科目ID 精确
     */
    @ApiModelProperty("科目ID")
    private Long accId;
    /**
     * 科目父级ID 精确
     */
    @ApiModelProperty("科目父级ID")
    private Long accParentId;
    /**
     * 原始预算金额 精确
     */
    @ApiModelProperty("原始预算金额")
    private BigDecimal originalAmt;
    /**
     * 预算金额 精确
     */
    @ApiModelProperty("预算金额")
    private BigDecimal budgetAmt;
    /**
     * 已拨付金额 精确
     */
    @ApiModelProperty("已拨付金额")
    private BigDecimal feeReleasedAmt;
    /**
     * 已使用金额 精确
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmt;
    /**
     * 可用金额 精确
     */
    @ApiModelProperty("可用金额")
    private BigDecimal availableAmt;
    /**
     * 占用金额 精确
     */
    @ApiModelProperty("占用金额")
    private BigDecimal occupyAmt;
    /**
     * 可配置化字段1 精确
     */
    @ApiModelProperty("可配置化字段1")
    private String configurableField1;
    /**
     * 可配置化字段2 精确
     */
    @ApiModelProperty("可配置化字段2")
    private String configurableField2;
    /**
     * 可配置化字段3 精确
     */
    @ApiModelProperty("可配置化字段3")
    private String configurableField3;
    /**
     * 明细控制  精确
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;
}
