package com.elitesland.tw.tw5.api.prd.cas.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cas.payload.PrdCasSettingPayload;
import com.elitesland.tw.tw5.api.prd.cas.query.PrdCasSettingQuery;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * cas_setting
 *
 * @author zoey
 * @date 2024-01-25
 */
public interface PrdCasSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdCasSettingVO}>
     */
    PagingVO<PrdCasSettingVO> queryPaging(PrdCasSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdCasSettingVO}>
     */
    List<PrdCasSettingVO> queryListDynamic(PrdCasSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdCasSettingVO}
     */
    PrdCasSettingVO queryByKey(Long key);


    /**
     * 通过appId查询
     *
     * @param appId 主键
     * @return {@link PrdCasSettingVO}
     */
    PrdCasSettingVO queryByAppId(String appId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdCasSettingVO}
     */
    PrdCasSettingVO insert(PrdCasSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdCasSettingVO}
     */
    PrdCasSettingVO update(PrdCasSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdCasSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
