package com.elitesland.tw.tw5.api.prd.partner.business.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.util.List;

/**
 * 客户账号授权
 *
 * @author wangly
 * @date 2024-12-05
 */
@Getter
@Setter
public class BusinessPartnerAccreditQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 业务伙伴bookId 精确 */
    @ApiModelProperty("业务伙伴bookId")
    private Long bookId;
    /** 授权账号 精确 */
    @ApiModelProperty("授权账号")
    private String account;
    /** 密码 精确 */
    @ApiModelProperty("密码")
    private String password;
    /** 授权状态 精确 */
    @ApiModelProperty("授权状态")
    private String accreditStatus;
    /** 授权结束日期 精确 */
    @ApiModelProperty("授权结束日期")
    private LocalDate accreditEndDate;
    /** 授权操作人ID 精确 */
    @ApiModelProperty("授权操作人ID")
    private Long operationId;
    /** 用户id */
    @ApiModelProperty("用户id")
    private Long userId;
    /** 员工表id */
    @ApiModelProperty("员工表id")
    private Long employeeId;
}
