package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessPartnerAccreditPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessPartnerAccreditQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessPartnerAccreditVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessPartnerProjectOverviewVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户账号授权
 *
 * @author wangly
 * @date 2024-12-05
 */
public interface BusinessPartnerAccreditService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessPartnerAccreditVO}>
     */
    PagingVO<BusinessPartnerAccreditVO> queryPaging(BusinessPartnerAccreditQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessPartnerAccreditVO}>
     */
    List<BusinessPartnerAccreditVO> queryListDynamic(BusinessPartnerAccreditQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessPartnerAccreditVO}
     */
    BusinessPartnerAccreditVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessPartnerAccreditVO}
     */
    BusinessPartnerAccreditVO insert(BusinessPartnerAccreditPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessPartnerAccreditVO}
     */
    BusinessPartnerAccreditVO update(BusinessPartnerAccreditPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessPartnerAccreditPayload payload);

    /**
     * 更新授权状态
     *
     * @return {@link long}
     */
    void updateAccreditStatus(Long key,String status);
    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 修改密码
     *
     * @param
     */
    void updatePasswordByUserId(Long userId,String newPassword);

    /**
     * 客户项目概览查询
     *
     * @param
     */
    BusinessPartnerProjectOverviewVO queryCustomerProjectOverview();

    /**
     * 客户授权项目列表查询
     *
     * @param
     */
    PagingVO<PmsProjectVO> queryCustomerProjectPaging(AccreditProjectSimpleQuery query);
}
