package com.elitesland.tw.tw5.api.prd.partner.business.vo;

import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSimpleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
public class BusinessPartnerProjectOverviewVO {

    @ApiModelProperty("项目总数")
    private BigDecimal totalProjectNum;

    @ApiModelProperty("项目列表")
    private List<PmsProjectVO> pmsProjectVOList;

    @ApiModelProperty("进行中的项目数")
    private BigDecimal underWayProjectNum;

    @ApiModelProperty("进行中的项目列表")
    private List<PmsProjectVO>  underWayProjectList;

    @ApiModelProperty("已完成的项目数")
    private BigDecimal completeProjectNum;

    @ApiModelProperty("已完成的项目列表")
    private List<PmsProjectVO>  completeProjectList;

    @ApiModelProperty("本月内验收数")
    private BigDecimal currentMonthCheckNum;

    @ApiModelProperty("本月内验收列表")
    private List<PmsProjectVO>  currentMonthCheckProjectList;

    @ApiModelProperty("项目类型占比")
    private Map<String, BigDecimal> projectTypeRatioMap;

    @ApiModelProperty("收款计划列表")
    private List<ConReceivablePlanVO> conReceivablePlanVOList;

    @ApiModelProperty("往来沟通记录")
    private List<PmsCommunicatePlanVO> pmsCommunicatePlanVOList;

    @ApiModelProperty("项目进度列表")
    private List<PmsProjectSimpleVO> pmsProjectSimpleVOList;

}
