package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
  * 业务伙伴-发票信息
  *
  * @author wangly
  * @date 2023-05-16
  */
@Getter
@Setter
public class BookInvoiceVO extends BaseViewModel implements Serializable {
    /** 地址薄id */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 发票信息 */
    @ApiModelProperty("发票信息")
    private String invoiceMessage;
    /** 发票抬头 */
    @ApiModelProperty("发票抬头")
    private String invoiceTitle;
    /** 税率 udc[prd:ab:tax_rate] */
    @ApiModelProperty("税率 udc[prd:ab:tax_rate]")
    private String taxRete;
    /** 税率 udc[prd:ab:tax_rate] */
    @ApiModelProperty("税率 udc[prd:ab:tax_rate]")
    @UdcName(udcName = "prd:ab:tax_rate",codePropName = "taxRete")
    private String taxReteDesc;

    /** 税号 */
    @ApiModelProperty("税号")
    private String taxNo;
    /** 开票类型 udc[prd:ab:inv_type] */
    @ApiModelProperty("开票类型 udc[prd:ab:inv_type]")
    private String invoiceType;
    @ApiModelProperty("开票类型翻译 udc[prd:ab:inv_type]")
    @UdcName(udcName = "prd:ab:inv_type",codePropName = "invoiceType")
    private String invoiceTypeName;

    /** 开票地址 */
    @ApiModelProperty("开票地址")
    private String invoiceAddress;
    /** 电话 */
    @ApiModelProperty("电话")
    private String invoicePhone;
    /** 开户行 */
    @ApiModelProperty("开户行")
    private String depositBank;
    /** 账户 */
    @ApiModelProperty("账户")
    private String invoiceAccount;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;
    @ApiModelProperty("币种翻译 udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY",codePropName = "currency")
    private String currencyDesc;
    @ApiModelProperty("币种翻译 udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY",codePropName = "currency")
    private String currencyName;
    /** 是否为默认开票信息 */
    @ApiModelProperty("是否为默认开票信息")
    private Boolean isDefault;


    @ApiModelProperty("行id")
    private String lineId;
}
