package com.elitesland.tw.tw5.api.prd.personplan.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * 相关方变化历史记录payload
 * @author wangxl
 * @date 2024/3/18
 */
@Data
@ApiModel(description = "相关方变化历史记录payload")
public class PmsRelatedHistoryPayload extends TwCommonPayload {

    @ApiModelProperty("相关方id")
    private Long relateId;

    @ApiModelProperty("利益相关程度")
    private Integer ext1;

    @ApiModelProperty("权利程度")
    private Integer ext2;

    @ApiModelProperty("情感倾向")
    private Integer ext3;

    @ApiModelProperty("参与度")
    private BigDecimal ext4;

    @ApiModelProperty("来源类型 1沟通计划 2项目初始 3手工修改")
    private Integer sourceType;

}