package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRolePayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;


import java.util.List;

/**
 * 项目角色
 *
 * @author xxb
 * @date 2023-07-07
 */
public interface PmsProjectRoleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectRoleVO}>
     */
    PagingVO<PmsProjectRoleVO> queryPaging(PmsProjectRoleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectRoleVO}>
     */
    List<PmsProjectRoleVO> queryListDynamic(PmsProjectRoleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectRoleVO}
     */
    PmsProjectRoleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectRoleVO}
     */
    PmsProjectRoleVO insert(PmsProjectRolePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectRoleVO}
     */
    PmsProjectRoleVO update(PmsProjectRolePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectRolePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
