package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Getter
@Setter
public class PmsProjectWbsRelyPayload extends TwCommonPayload  implements Serializable {
    /** 项目主键 */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /** wbs主键(依赖建立着，后置任务) */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private Long wbsId;
    /** wbs名称(依赖建立着，后置任务，冗余字段) */
    @ApiModelProperty("wbs名称(依赖建立着，后置任务，冗余字段)")
    private String wbsName;
    /** wbs主键(依赖前置任务) */
    @ApiModelProperty("wbs主键(依赖前置任务)")
    private Long wbsRelyId;
    /** wbs名称(前置依赖名称，冗余字段） */
    @ApiModelProperty("wbs名称(前置依赖名称，冗余字段）")
    private String wbsRelyName;
    /** 前置类型（FS） */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;

    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;
}
