package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsLogQuery extends TwQueryParam implements Serializable {
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    @Query
    private Long projectId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;
    /**
     * 节点主键
     */
    @ApiModelProperty("节点主键")
    @Query
    private Long wbsId;
    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    private String operType;
    /**
     * wbs类型(WBS,NET,ACT,MS) 精确
     */
    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS)")
    private String wbsType;
    /**
     * 日志内容
     */
    @ApiModelProperty("日志内容")
    private String logContent;

}
