package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 项目wbs前置依赖关系模板query
 * @author wangxl
 * @date 2024/4/2
 */
@Data
@ApiModel(description = "项目wbs前置依赖关系模板query")
public class PmsProjectWbsRelyTempQuery extends TwQueryParam {

    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;

    /**
     * wbs主键(依赖建立着，后置任务)
     */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private Long wbsId;

    /**
     * wbs名称(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs名称(依赖建立着，后置任务，冗余字段)")
    private String wbsName;

    /**
     * wbs主键(依赖前置任务)
     */
    @ApiModelProperty("wbs主键(依赖前置任务)")
    private Long wbsRelyId;

    /**
     * wbs名称(前置依赖名称，冗余字段）
     */
    @ApiModelProperty("wbs名称(前置依赖名称，冗余字段）")
    private String wbsRelyName;

    /**
     * 前置类型（FS）
     */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;

    /**
     * 关系类型
     */
    @ApiModelProperty("关系类型")
    private String relationType;

    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * 有效关联id
     */
    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    /**
     * 数据归属组织id
     */
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;

    /**
     * 数据归属雇员id
     */
    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;

    /**
     * 数据归属公司id
     */
    @ApiModelProperty("数据归属公司id")
    private Long secOuId;

}