package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCountVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoCountVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.checkerframework.checker.units.qual.A;

import java.io.Serializable;
import java.util.List;

@Data
public class PmsProjectOverviewVO implements Serializable {

    @ApiModelProperty("项目详情")
    private PmsProjectVO pmsProjectVO;

    @ApiModelProperty("项目任务")
    private TaskInfoCountVO taskInfoCountVO;

    @ApiModelProperty("项目成员")
    private List<ProRelatedPartiesVO> proRelatedPartiesVOList;

    @ApiModelProperty("项目成风险事件")
    private List<PmsProjectEventLogVO> pmsProjectEventLogVOList;

    @ApiModelProperty("项目变更事件")
    private List<ComChangeVO> comChangeVOList;

    @ApiModelProperty("项目收款")
    private List<PmsProjectReceiveVO> pmsProjectReceiveVOList;

    @ApiModelProperty("项目付款")
    private List<PmsProjectPurContractVO> pmsProjectPurContractVOList;

    @ApiModelProperty("项目预算")
    private BudgetCountVO budgetCountVO;
}
