package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;

import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
public interface PurchaseContractDetailsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseContractDetailsVO}>
     */
    PagingVO<PurchaseContractDetailsVO> queryPaging(PurchaseContractDetailsQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseContractDetailsVO}>
     */
    List<PurchaseContractDetailsVO> queryListDynamic(PurchaseContractDetailsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseContractDetailsVO}
     */
    PurchaseContractDetailsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseContractDetailsVO}
     */
    PurchaseContractDetailsVO insert(PurchaseContractDetailsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseContractDetailsVO}
     */
    PurchaseContractDetailsVO update(PurchaseContractDetailsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据采购合同Id查询采购明细
     * @param purConId 采购合同Id
     * @return 采购明细
     */
    List<PurConOrAgreementDetailsSimpleVO> queryByPurConId(Long purConId);
}
