package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;
import java.util.List;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
@Getter
@Setter
public class ConReceivablePayload extends TwCommonPayload  implements Serializable {
    /** 收款批次号 */
    @ApiModelProperty("收款批次号")
    private String recvNo;
    /** 收款类别 发票收款/预收款 */
    @ApiModelProperty("收款类别 发票收款/预收款")
    private String recvClass;
    /** 来源ID */
    @ApiModelProperty("来源ID")
    private Long sourceId;
    /** 收款金额 */
    @ApiModelProperty("收款金额")
    private BigDecimal recvAmt;
    /** 收款日期 */
    @ApiModelProperty("收款日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recvDate;
    /** 银行账号 */
    @ApiModelProperty("银行账号")
    private String accountNo;
    /** 总账日期 */
    @ApiModelProperty("总账日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate ledgerDate;

    /**
     * 收款明细表
     */
    private List<ConReceivableDPayload> detailList;
}
