package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Getter
@Setter
public class ConInvBatchQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private List<Long> ids;
    /** 批次号 模糊 */
    @ApiModelProperty("批次号")
    private String batchNo;
    /** 批次状态 已申请/待开票/已开票/已取消 精确 */
    @ApiModelProperty("批次状态 已申请/待开票/已开票/已取消")
    private String batchStatus;

    private List<String> batchStatusList;
    /** prd_ab_invoice 发票信息ID 模糊 */
    @ApiModelProperty("prd_ab_invoice 发票信息ID")
    private Long invoiceId;
    /** 发票抬头 模糊 */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /** 发票类型 精确 */
    @ApiModelProperty("发票类型")
    private String invType;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 递送方式 精确 */
    @ApiModelProperty("递送方式")
    private String deliMethod;
    /** 收件人 精确 */
    @ApiModelProperty("收件人")
    private String contactPerson;
    /** 收件人地址 文本录入 精确 */
    @ApiModelProperty("收件人地址 文本录入")
    private String invAddr;
    /** 收件人电话 精确 */
    @ApiModelProperty("收件人电话")
    private String invTel;
    /** 开户行 精确 */
    @ApiModelProperty("开户行")
    private String bankName;
    /** 账号 模糊 */
    @ApiModelProperty("账号")
    private String accountNo;
//    /** 开票日期 精确 */
//    @ApiModelProperty("开票日期")
//    private LocalDate batchDate;
    /** 开票日期 范围 */
    @ApiModelProperty("开票日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> batchDate;


    /** 发票内容 精确 */
    @ApiModelProperty("发票内容")
    private String invContent;
    /** 付款方式 精确 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 开票说明 精确 */
    @ApiModelProperty("开票说明")
    private String invDesc;
    /** 开票主体公司ID 精确 */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;

    /**
     * 部门权限
     */
    private Set<Long> authOuIds;

    /** 开票金额 精确 */
    @ApiModelProperty("开票金额")
    private BigDecimal invAmt;
    /** 是否自动保存开票信息到地址簿 0 不保存 1保存 精确 */
    @ApiModelProperty("是否自动保存开票信息到地址簿 0 不保存 1保存")
    private Integer saveAbFlag;
    /** 预计到账日期 精确 */
    @ApiModelProperty("预计到账日期")
    private LocalDate antiRecvDate;
    /** 地址 存放地址簿中的信息 精确 */
    @ApiModelProperty("地址 存放地址簿中的信息")
    private String addr;
    /** 退票原因 精确 */
    @ApiModelProperty("退票原因")
    private String disDisc;
    /** 收件人邮箱 精确 */
    @ApiModelProperty("收件人邮箱")
    private String invEmail;
    /** 发票商品ID 关联 T_INVOICE_ITEM.ID 精确 */
    @ApiModelProperty("发票商品ID 关联 T_INVOICE_ITEM.ID")
    private Long invItemId;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    /**
     * 客户名称
     */
    @ApiModelProperty("客户id")
    private Long custId;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 主合同名称
     */
    @ApiModelProperty("主合同名称")
    private String contractName;

    /**
     * 子合同号
     */
    @ApiModelProperty("子合同号")
    private String subContractNo;

    /**
     * 子合同名称
     */
    @ApiModelProperty("子合同名称")
    private String subContractName;

    /**
     * 发票号码
     */
    private String invNo;

    /** 预计收款日期 范围 */
    @ApiModelProperty("预计收款日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> expectReceDate;


    /** 预计收款日期 范围 */
    @ApiModelProperty("实际开票日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> actualDate;

    /** PMO*/
    @ApiModelProperty("PMO")
    private Long pmoUserId;

    /**
     * 逾期天数
     */
    private Long overDays;

    /**销售子合同id(用于退票解绑后，记录销售子合同来源，项目汇报用此字段)*/
    private Long saleContractId;

    /**
     * 发票状态
     */
    private String invStatus;


    /**
     * 退票日期
     */
    private List<LocalDate> refundDate;


    /** jde单据公司 精确 */
    @ApiModelProperty("jde单据公司")
    private String jdeCompany;
    /** jde单据号  精确 */
    @ApiModelProperty("jde单据号 ")
    private String jdeDocumentNo;
    /** jde单据类型 精确 */
    @ApiModelProperty("jde单据类型")
    private String jdeDocumentType;
    /** jde付款项 精确 */
    @ApiModelProperty("jde付款项")
    private String jdePaymentItem;
    /** jde发票凭证 精确 */
    @ApiModelProperty("jde发票凭证")
    private String jdeInvoiceVoucher;
    /** jde发票凭证失败原因 精确 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeInvoiceFailReason;

    @ApiModelProperty("jde发票凭证状态")
    private String jdeInvoiceStatus;

    @ApiModelProperty("jde核销收款状态")
    private String jdeReceiveWriteOffStatus;
}
