package com.elitesland.tw.tw5.api.prd.task.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 节点任务
 *
 * @author xxb
 * @date 2023-07-11
 */
@Getter
@Setter
public class PmsWbsTaskPayload extends TwCommonPayload  implements Serializable {
    /** 项目主键 */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /** wbs主键 */
    @ApiModelProperty("wbs主键")
    private Long wbsId;
    /** 资源类型(labour人工、material材料、device设备) */
    @ApiModelProperty("资源类型(labour人工、material材料、device设备)")
    private String sourceType;
    /** 发包人id */
    @ApiModelProperty("发包人id")
    private Long disterUserId;
    /** 接包人id */
    @ApiModelProperty("接包人id")
    private Long receiverUserId;
    /** 任务编号 */
    @ApiModelProperty("任务编号")
    private String taskCode;
    /** 任务名称 */
    @ApiModelProperty("任务名称")
    private String taskName;
    /** 任务状态 */
    @ApiModelProperty("任务状态")
    private String taskStatus;
    /** 任务开始时间 */
    @ApiModelProperty("任务开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /** 任务结束时间 */
    @ApiModelProperty("任务结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;
    /** 派发人天 */
    @ApiModelProperty("派发人天")
    private BigDecimal days;
    /** 角色主键 */
    @ApiModelProperty("角色主键")
    private Long projectRoleId;

    @ApiModelProperty("进度")
    private BigDecimal progress;

    @ApiModelProperty("权重")
    private BigDecimal weight;

    @ApiModelProperty("任务说明")
    private String taskExplain;

    @ApiModelProperty("交付文档")
    private String deliveryDocuments;

    /**
     * 权重设置方式：1为手动设置  0为系统设置
     */
    @ApiModelProperty("权重设置方式：1为手动设置  0为系统设置")
    private Integer manualSettingWeight;
}
