package com.elitesland.tw.tw5.api.prd.task.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-17
 */
@Getter
@Setter
public class TaskPayload extends TwCommonPayload implements Serializable {

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    //
//    @ApiModelProperty("任务包ID")
//    private Long taskPackageId;
//    @ApiModelProperty("任务包名称")
//    private String taskPackageName;
//
//    @ApiModelProperty(value = "发包资源id")
//    private Long disterResId;
    @ApiModelProperty("任务来源类型null或1是普通任务，2奖励假任务")
    private String sourceType;
    @ApiModelProperty("来源id（如果是奖励假申请则是奖励假申请id）")
    private Long sourceId;

    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    
    @ApiModelProperty("上级任务ID")
    private Long taskParentId;

    @ApiModelProperty(value = "申请标记：true 为申请 默认false")
    private Boolean applyFlag = false;

    @ApiModelProperty(value = "派发标记：true派发 默认false")
    private Boolean distributeFlag = false;

    @ApiModelProperty(value = "任务列表")
    private List<TaskInfoPayload> taskInfoPayloads;
    /**
     * 任务场景id(任务类别)
     */
    @ApiModelProperty("任务场景id")
    private Long taskSceneId;
}
