package com.elitesland.tw.tw5.api.authconfig.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;


/**
  * 银企直连授权配置
  *
  * @author duwh
  * @date 2023-11-10
  */
@Getter
@Setter
public class BkAuthConfigVO extends BaseViewModel implements Serializable {
    /** 调用方平台 */
    @ApiModelProperty("调用方平台")
    private String platform;
    /** 调用银行 */
    @ApiModelProperty("调用银行")
    private String bank;
    /** ip */
    @ApiModelProperty("ip")
    private String ip;
    /** 秘钥 */
    @ApiModelProperty("秘钥")
    private String secretKey;
    /** 是否可用 0不可用 1可用 */
    @ApiModelProperty("是否可用 0不可用 1可用")
    private Boolean enabled;
    /** 链接类型 inner 内部路由（服务间调用） outer 外部链接（http://xxx） */
    @ApiModelProperty("链接类型 inner 内部路由（服务间调用） outer 外部链接（http://xxx）")
    private String hrefType;
    /** 内部路由地址 http://tw-server5 */
    @ApiModelProperty("内部路由地址 http://tw-server5")
    private String innerHref;
    /** 外部链接 如http://www.elitesland.com */
    @ApiModelProperty("外部链接 如http://www.elitesland.com")
    private String outerHref;
    /** 根据平台不同，所需的配置不同，银企配置 */
    @ApiModelProperty("根据平台不同，所需的配置不同，银企配置")
    private String configJson;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
}
