package com.elitesland.tw.tw5.api.bank.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 付款结果
 *
 * @author duwh
 * @date 2023-11-08
 */
@Getter
@Setter
public class BkPayResultQuery extends TwQueryParam implements Serializable{
    /** 付款明细表id 精确 */
    @ApiModelProperty("付款明细表id")
    private Integer bkPayDetailId;
    /** 流程实例号 精确 */
    @ApiModelProperty("流程实例号")
    private String reqnbr;
    /** 事件实例号 精确 */
    @ApiModelProperty("事件实例号")
    private String evtlst;
    /** 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账 精确 */
    @ApiModelProperty("业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账")
    private String rtnflag;
    /** 银行失败码 精确 */
    @ApiModelProperty("银行失败码")
    private String errorCode;
    /** 失败原因 精确 */
    @ApiModelProperty("失败原因")
    private String errorReason;
    /** 请求状态OPR 接收中NTE 待处理 FIN 完成 精确 */
    @ApiModelProperty("请求状态OPR 接收中NTE 待处理 FIN 完成")
    private Integer reqsts;
    /** （代发）请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中 精确 */
    @ApiModelProperty("（代发）请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中")
    private String reqsta;
    /** 付款账号 精确 */
    @ApiModelProperty("付款账号")
    private String accnbr;
    /** 付方户名 精确 */
    @ApiModelProperty("付方户名")
    private String accnam;
    /** 总金额 精确 */
    @ApiModelProperty("总金额")
    private BigDecimal ttlamt;
    /** 本次金额 精确 */
    @ApiModelProperty("本次金额")
    private BigDecimal curamt;
    /** 交易类型 精确 */
    @ApiModelProperty("交易类型")
    private String trstrp;
    /** 用途 精确 */
    @ApiModelProperty("用途")
    private String nusage;
    /** 期望日期 精确 */
    @ApiModelProperty("期望日期")
    private String eptdat;
    /** 期望时间 精确 */
    @ApiModelProperty("期望时间")
    private String epttim;
    /** 单据类型：1.代发 2.支付（用于接口区分数据） 精确 */
    @ApiModelProperty("单据类型：1.代发 2.支付（用于接口区分数据）")
    private Integer orderType;
    /** 收方行联行号 精确 */
    @ApiModelProperty("收方行联行号")
    private String brdnbr;
    /** 记账子单元 精确 */
    @ApiModelProperty("记账子单元")
    private String dmanbr;
    /** 结算通道(代发)Y 超网 N 大小额 精确 */
    @ApiModelProperty("结算通道(代发)Y 超网 N 大小额")
    private String chlflg;
    /** 业务模式 精确 */
    @ApiModelProperty("业务模式")
    private String busmod;
    /** 他行户口开户行 精确 */
    @ApiModelProperty("他行户口开户行")
    private String eacbnk;
    /** 他行户口开户地 精确 */
    @ApiModelProperty("他行户口开户地")
    private String eaccty;
    /** 单据编号：合同号/报销单号 精确 */
    @ApiModelProperty("单据编号：合同号/报销单号")
    private String ctrnbr;
    /** 发票号 精确 */
    @ApiModelProperty("发票号")
    private String invnbr;
    /** 业务参考号 精确 */
    @ApiModelProperty("业务参考号")
    private String yurref;
    /** 删除标志 精确 */
    @ApiModelProperty("删除标志")
    private Integer delFlag;
    /**  精确 */
    @ApiModelProperty("")
    private String podurl;
}
