package com.elitesland.tw.tw5.api.bank.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.payload.BkPayDetailPayload;
import com.elitesland.tw.tw5.api.bank.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.query.BkPayDetailQuery;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;

import java.util.List;

/**
 * 付款明细表
 *
 * @author duwh
 * @date 2023-11-10
 */
public interface BkPayDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BkPayDetailVO}>
     */
    PagingVO<BkPayDetailVO> queryPaging(BkPayDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BkPayDetailVO}>
     */
    List<BkPayDetailVO> queryListDynamic(BkPayDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BkPayDetailVO}
     */
    BkPayDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BkPayDetailVO}
     */
    BkPayDetailVO insert(BkPayDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BkPayDetailVO}
     */
    BkPayDetailVO update(BkPayDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BkPayDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    void pay(PayPayload payload);
}
