package com.elitesland.tw.tw5.api.bank.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.payload.BkPayResultPayload;
import com.elitesland.tw.tw5.api.bank.query.BkPayResultQuery;
import com.elitesland.tw.tw5.api.bank.vo.BkPayResultVO;

import java.util.List;

/**
 * 付款结果
 *
 * @author duwh
 * @date 2023-11-08
 */
public interface BkPayResultService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BkPayResultVO}>
     */
    PagingVO<BkPayResultVO> queryPaging(BkPayResultQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BkPayResultVO}>
     */
    List<BkPayResultVO> queryListDynamic(BkPayResultQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BkPayResultVO}
     */
    BkPayResultVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BkPayResultVO}
     */
    BkPayResultVO insert(BkPayResultPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BkPayResultVO}
     */
    BkPayResultVO update(BkPayResultPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BkPayResultPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
