package com.elitesland.tw.tw5.api.bank.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 付款明细表
 *
 * @author duwh
 * @date 2023-11-10
 */
@Getter
@Setter
public class BkPayDetailQuery extends TwQueryParam implements Serializable{
    /** 流程实例号 精确 */
    @ApiModelProperty("流程实例号")
    private String reqnbr;
    /** 事件实例号 精确 */
    @ApiModelProperty("事件实例号")
    private String evtlst;
    /** 批次编号 精确 */
    @ApiModelProperty("批次编号")
    private String bthnbr;
    /** 业务参考号 精确 */
    @ApiModelProperty("业务参考号")
    private String yurref;
    /** 交易流水号 精确 */
    @ApiModelProperty("交易流水号")
    private String refnbr;
    /** 付款凭证url 精确 */
    @ApiModelProperty("付款凭证url")
    private String podurl;
    /** 付款户名 精确 */
    @ApiModelProperty("付款户名")
    private String payaccnam;
    /** 付款账号 精确 */
    @ApiModelProperty("付款账号")
    private String payaccnbr;
    /** 收账号 精确 */
    @ApiModelProperty("收账号")
    private String accnbr;
    /** 收户名 精确 */
    @ApiModelProperty("收户名")
    private String accnam;
    /** 总金额 精确 */
    @ApiModelProperty("总金额")
    private BigDecimal ttlamt;
    /** 总笔数 精确 */
    @ApiModelProperty("总笔数")
    private Integer ttlcnt;
    /** 总次数 精确 */
    @ApiModelProperty("总次数")
    private Integer ttlnum;
    /** 本次金额 精确 */
    @ApiModelProperty("本次金额")
    private BigDecimal curamt;
    /** 本次次数 精确 */
    @ApiModelProperty("本次次数")
    private Integer curcnt;
    /** 合作方协议号 精确 */
    @ApiModelProperty("合作方协议号")
    private String cnvnbr;
    /** 币种：10人民币 精确 */
    @ApiModelProperty("币种：10人民币")
    private Integer ccynbr;
    /** 个性化短信 精确 */
    @ApiModelProperty("个性化短信")
    private String ntfinf;
    /** 交易类型 精确 */
    @ApiModelProperty("交易类型")
    private String trstrp;
    /** 用途 精确 */
    @ApiModelProperty("用途")
    private String nusage;
    /** 期望日期 精确 */
    @ApiModelProperty("期望日期")
    private String eptdat;
    /** 期望时间 精确 */
    @ApiModelProperty("期望时间")
    private String epttim;
    /** 结算通道(代发)Y 超网 N 大小额 精确 */
    @ApiModelProperty("结算通道(代发)Y 超网 N 大小额")
    private String chlflg;
    /** 系统内标识 精确 */
    @ApiModelProperty("系统内标识")
    private String bnkflg;
    /** 他行户口开户行 精确 */
    @ApiModelProperty("他行户口开户行")
    private String eacbnk;
    /** 他行户口开户地 精确 */
    @ApiModelProperty("他行户口开户地")
    private String eaccty;
    /** 合作方流水号 精确 */
    @ApiModelProperty("合作方流水号")
    private String cprref;
    /** 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。 精确 */
    @ApiModelProperty("请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。")
    private String reqsta;
    /** 交易序号 精确 */
    @ApiModelProperty("交易序号")
    private String trxseq;
    /** 保留字段 精确 */
    @ApiModelProperty("保留字段")
    private String rsv100;
    /** 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票 精确 */
    @ApiModelProperty("付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票")
    private Integer payStatus;
    /** 单据类型：1.代发 2.支付（用于接口区分数据） 精确 */
    @ApiModelProperty("单据类型：1.代发 2.支付（用于接口区分数据）")
    private Integer orderType;
    /** 交易状态：E：失败 A: 登记 S: 成功 精确 */
    @ApiModelProperty("交易状态：E：失败 A: 登记 S: 成功")
    private String stscod;
    /** 收方开户行名称 精确 */
    @ApiModelProperty("收方开户行名称")
    private String crtbnk;
    /** 收方开户行地址 精确 */
    @ApiModelProperty("收方开户行地址")
    private String crtadr;
    /** 收方行联行号 精确 */
    @ApiModelProperty("收方行联行号")
    private String brdnbr;
    /** 交易金额 精确 */
    @ApiModelProperty("交易金额")
    private BigDecimal trsamt;
    /** 业务种类100001    普通汇兑 （默认值）;101001    慈善捐款; 101002    其他  精确 */
    @ApiModelProperty("业务种类100001    普通汇兑 （默认值）;101001    慈善捐款; 101002    其他 ")
    private String trstyp;
    /** G 普通；Q 快速；R 实时-超网 精确 */
    @ApiModelProperty("G 普通；Q 快速；R 实时-超网")
    private String stlchn;
    /** 直汇普通标志：A-普通 B-直汇 精确 */
    @ApiModelProperty("直汇普通标志：A-普通 B-直汇")
    private String drpflg;
    /** 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账 精确 */
    @ApiModelProperty("业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账")
    private String ftnflg;
    /** 银行失败码 精确 */
    @ApiModelProperty("银行失败码")
    private String errorCode;
    /** 批量标识:1.单条 2.批量  （用于支付接口） 精确 */
    @ApiModelProperty("批量标识:1.单条 2.批量  （用于支付接口）")
    private Integer batchFlag;
    /** 失败原因 精确 */
    @ApiModelProperty("失败原因")
    private String errorReason;
    /** 删除标志 精确 */
    @ApiModelProperty("删除标志")
    private Integer delFlag;
    /** 单据id 精确 */
    @ApiModelProperty("单据id")
    private String docId;
    /** 单据编号 精确 */
    @ApiModelProperty("单据编号")
    private String docNo;
    /** 单据类型 精确 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 用户id 精确 */
    @ApiModelProperty("用户id")
    private String usrId;
    /** 用户姓名 */
    @ApiModelProperty("用户姓名")
    private String usrName;
}
