package com.elitesland.tw.tw5.api.authconfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.authconfig.payload.BkAuthConfigPayload;
import com.elitesland.tw.tw5.api.authconfig.query.BkAuthConfigQuery;
import com.elitesland.tw.tw5.api.authconfig.vo.BkAuthConfigVO;

import java.util.List;

/**
 * 银企直连授权配置
 *
 * @author duwh
 * @date 2023-11-10
 */
public interface BkAuthConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BkAuthConfigVO}>
     */
    PagingVO<BkAuthConfigVO> queryPaging(BkAuthConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BkAuthConfigVO}>
     */
    List<BkAuthConfigVO> queryListDynamic(BkAuthConfigQuery query);

    /**
     * 查询列表 获取第一条
     *
     * @param query 查询
     * @return {@link BkAuthConfigVO}
     */
    BkAuthConfigVO fetchFirst(BkAuthConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BkAuthConfigVO}
     */
    BkAuthConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BkAuthConfigVO}
     */
    BkAuthConfigVO insert(BkAuthConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BkAuthConfigVO}
     */
    BkAuthConfigVO update(BkAuthConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BkAuthConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
