package com.elitesland.tw.tw5.api.bank.constants.cmb;

/**
 * 系统内标识 Y 收方为招商银行账号      N收方为他行账户
 *
 * @author duwh
 * @date 2023/11/10
 */
public enum CmbPaySystemEnum {

    YES("Y", "收方为招商银行账号"),
    NO("N", "收方为他行账户");
    private String type;
    private String comment;

    CmbPaySystemEnum(String type, String comment) {
        this.type = type;
        this.comment = comment;
    }

    public String getType() {
        return type;
    }

    public String getComment() {
        return comment;
    }

    public static String getDesc(String value) {
        CmbPaySystemEnum[] paySystemEnums = values();
        for (CmbPaySystemEnum paySystemEnum : paySystemEnums) {
            if (paySystemEnum.getType().equals(value)) {
                return paySystemEnum.getComment();
            }
        }
        return "";
    }
}
