package com.elitesland.tw.tw5.api.bank.feign.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayListPayload;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "tw-bank")
public interface TwBankPayService {

    /**
     * 发起付款
     *
     * @param payload 有效载荷
     *                platform 必填
     *                bank 必填
     *                secretKey 必填
     * @return {@link ApiResult}<{@link BkPayDetailVO}>
     */
    @PostMapping("/api/open/bank/pay")
    @ApiOperation("发起付款-新增")
    ApiResult<BkPayDetailVO> pay(@RequestBody PayPayload payload);

    /**
     * 批量发起付款
     *
     * @param payload 有效载荷
     *                platform 必填
     *                bank 必填
     *                secretKey 必填
     *                payPayloadList[*].platform 不需要填写
     *                payPayloadList[*].bank 不需要填写
     *                payPayloadList[*].secretKey 不需要填写
     * @return {@link ApiResult}<{@link List}<{@link BkPayDetailVO}>>
     */
    @PostMapping("/api/open/bank/payList")
    @ApiOperation("批量发起付款-新增")
    ApiResult<List<BkPayDetailVO>> payList(@RequestBody PayListPayload payload);


}

