package com.elitesland.tw.tw5.api.bank.callback.cmb;

import lombok.Getter;
import lombok.Setter;

/**
 * 回调参数
 *
 * @author duwh
 * @date 2023/11/10
 */
@Getter
@Setter
public class CmbCallBackPayload {

    /**
     * 单据主键
     */
    private String docId;
    /**
     * 单据类型 ,可能为空
     */
    private String docType;

    /**
     * 付款状态
     *  SEND(1, "待发送"),
     *  SELECT(2, "待查询"),
     *  PAYMENT(3, "待支付"),
     *  PAYIN(3, "支付中"),
     *  SUCCESS(4, "成功"),
     *  FAIL(5, "失败"),
     *  PAYRETURN(6, "支付退票");
     *
     */
    private String payState;

}
