package com.elitesland.tw.tw5.api.bank.constants.cmb;

/**
 * 支付状态详细信息枚举
 *
 * @author duwh
 * @date 2023/11/10
 */
public enum CmbPayStatusDetailEnum {

    SEND(1, "待发送"),
    SELECT(2, "待查询"),
    PAYMENT(3, "待支付"),
    PAYIN(3, "支付中"),
    SUCCESS(4, "成功"),
    FAIL(5, "失败"),
    PAYRETURN(6, "支付退票");
    private int type;
    private String comment;

    public int getType() {
        return type;
    }

    public String getComment() {
        return comment;
    }

    CmbPayStatusDetailEnum(int type, String comment) {
        this.type = type;
        this.comment = comment;
    }



}
