package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAccountService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 银行账户管理
 *
 * @author carl.wang
 */
@Api("银行账户管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ab")
@Slf4j
public class PrdAbAccountController {

    private final PrdAbAccountService service;

    /**
     * 银行账户新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/account/insert")
    public TwOutputUtil insert(PrdAbAccountPayload payload) {
        Assert.notNull(payload.getBookId(),"bookId is not null");
        Assert.hasText(payload.getAccountType(),"请选择账户类型");
        Assert.hasText(payload.getAccountNo(),"请输入账号");
        // 同一种账号类型只能有一个设置为默认
        if (payload.getDefaultFlag() != null && payload.getDefaultFlag()) {
            List<PrdAbAccountVO> abAccountVOList = service.queryList(payload.getBookId(), payload.getAccountType(), payload.getDefaultFlag(),null);
            if (abAccountVOList.size() > 0) {
                return TwOutputUtil.error("999", "同一种账号类型只能有一个设为默认", payload);
            }
        }
        // 相同账户类型，账号唯一性校验
        List<PrdAbAccountVO> abAccountVOList = service.queryList(payload.getBookId(), payload.getAccountType(), null, payload.getAccountNo());
        if (abAccountVOList.size() > 0) {
            return TwOutputUtil.error("999", "账号重复，请重新输入", payload);
        }
        PrdAbAccountVO vo = service.save(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/account/update")
    public TwOutputUtil update(PrdAbAccountPayload payload) {
        Assert.notNull(payload.getBookId(),"bookId is not null");
        Assert.hasText(payload.getAccountType(),"请选择账户类型");
        Assert.hasText(payload.getAccountNo(),"请输入账号");
        // 同一种账号类型只能有一个设置为默认
        if (payload.getDefaultFlag() != null && payload.getDefaultFlag()) {
            List<PrdAbAccountVO> abAccountVOList = service.queryList(payload.getBookId(), payload.getAccountType(), payload.getDefaultFlag(),null);
            final long count = abAccountVOList.stream().filter(prdAbAccountVO -> !prdAbAccountVO.getId().equals(payload.getId())).count();
            if (count > 0) {
                return TwOutputUtil.error("999", "同一种账号类型只能有一个设为默认", payload);
            }
        }
        // 账户类型为银行
        if (payload.getAccountType().equals("1")) {
            List<PrdAbAccountVO> abAccountVOList = service.queryList(payload.getBookId(), payload.getAccountType(), null, payload.getAccountNo());
            final long count = abAccountVOList.stream().filter(prdAbAccountVO -> !prdAbAccountVO.getId().equals(payload.getId())).count();
            if (count > 0) {
                return TwOutputUtil.error("999", "账号重复，请重新输入", payload);
            }
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 删除
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param keys       主键id
     * @return result
     */
    @DeleteMapping("/account/delete")
    public TwOutputUtil delete(Long bookId, String objectType, Long[] keys) {
        service.delete(bookId, objectType, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param bookId 地址薄主键
     * @return result
     */
    @GetMapping("/account/queryList")
    public TwOutputUtil queryList(Long bookId) {
        return TwOutputUtil.ok(service.queryList(bookId));
    }
}
