package com.elitesland.tw.tw5.server.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlConfPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlConfQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlConfService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlConfVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.shorturl.convert.ShortUrlConfConvert;
import com.elitesland.tw.tw5.server.prd.shorturl.dao.ShortUrlConfDAO;
import com.elitesland.tw.tw5.server.prd.shorturl.entity.ShortUrlConfDO;
import com.elitesland.tw.tw5.server.prd.shorturl.repo.ShortUrlConfRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

/**
 * 短链服务配置
 *
 * @author duwh
 * @date 2023-05-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ShortUrlConfServiceImpl extends BaseServiceImpl implements ShortUrlConfService {

    private final ShortUrlConfRepo shortUrlConfRepo;
    private final ShortUrlConfDAO shortUrlConfDAO;

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public PagingVO<ShortUrlConfVO> queryPaging(ShortUrlConfQuery query) {
        return shortUrlConfDAO.queryPaging(query);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public List<ShortUrlConfVO> queryListDynamic(ShortUrlConfQuery query) {
        return shortUrlConfDAO.queryListDynamic(query);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public long count(ShortUrlConfQuery query) {
        return shortUrlConfDAO.count(query);
    }

    @Override
    public ShortUrlConfVO queryByKey(Long key) {
        ShortUrlConfDO entity = shortUrlConfRepo.findById(key).orElseGet(ShortUrlConfDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ShortUrlConfVO vo = ShortUrlConfConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public ShortUrlConfVO insert(ShortUrlConfPayload payload) {
        check(payload);

        ShortUrlConfQuery query = new ShortUrlConfQuery();
        query.setShortUrlPre(payload.getShortUrlPre());
        query.setLongUrlPre(payload.getLongUrlPre());
        Long tenantId = GlobalUtil.getTenantId();
        query.setSecTenantId(tenantId);
        long count = count(query);
        if (count > 0) {
            throw TwException.error("", "重复添加");
        }
        ShortUrlConfDO entityDo = ShortUrlConfConvert.INSTANCE.toDo(payload);
        entityDo.setSecTenantId(tenantId);
        return ShortUrlConfConvert.INSTANCE.toVo(shortUrlConfRepo.save(entityDo));
    }

    private void check(ShortUrlConfPayload payload) {
        if (ObjectUtils.isEmpty(payload.getShortUrlPre())) {
            throw TwException.error("", "shortUrlPre不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getLongUrlPre())) {
            throw TwException.error("", "longUrlPre不能为空");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public ShortUrlConfVO update(ShortUrlConfPayload payload) {
        ShortUrlConfDO entity = shortUrlConfRepo.findById(payload.getId()).orElseGet(ShortUrlConfDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ShortUrlConfDO entityDo = ShortUrlConfConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ShortUrlConfConvert.INSTANCE.toVo(shortUrlConfRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ShortUrlConfDO> optional = shortUrlConfRepo.findById(id);
                if (!optional.isEmpty()) {
                    ShortUrlConfDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    shortUrlConfRepo.save(entity);
                }
            });
        }
    }

}
