package com.elitesland.tw.tw5.server.common;

import com.elitesland.workflow.exception.WorkflowException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 统一异常处理
 *
 * @author duwh
 * @date 2023/03/29
 */
@ControllerAdvice
@Slf4j
public class TwExceptionHandler {

    /**
     * 兜底异常处理
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(Exception.class)
    @ResponseBody
    public TwOutputUtil exceptionHandler(Exception exception) {
        log.error(exception.getMessage(), exception);
        return TwOutputUtil.addException(exception);
    }

    /**
     * 业务异常处理
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(TwException.class)
    @ResponseBody
    public TwOutputUtil exceptionHandler(TwException exception) {
        return TwOutputUtil.addTwException(exception);
    }

    /**
     * 不在线异常处理程序
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(NotOnlineException.class)
    @ResponseBody
    public TwOutputUtil notOnlineExceptionHandler(NotOnlineException exception) {
        return TwOutputUtil.addNotOnlineException(exception);
    }

    /**
     * 工作流异常处理程序
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(WorkflowException.class)
    @ResponseBody
    public TwOutputUtil workflowExceptionHandler(WorkflowException exception) {
        return TwOutputUtil.addWorkflowException(exception);
    }

}
