/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarSharePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarSharePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarShareVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdCalendarConvert;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdCalendarShareConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarShareDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarShareDO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdCalendarServiceImpl
implements PrdCalendarService {
    private static final Logger log = LoggerFactory.getLogger(PrdCalendarServiceImpl.class);
    private final PrdCalendarDAO dao;
    private final PrdCalendarShareDAO calendarShareDAO;
    private final QyWxCommunicationService wxService;
    private final PrdOrgEmployeeDAO employeeDAO;

    @Transactional
    public PrdCalendarVO insertOrUpdate(PrdCalendarPayload payload) {
        String loginUserName;
        if (payload.getTitle() != null && payload.getTitle().contains("undefined")) {
            String title = payload.getTitle();
            loginUserName = GlobalUtil.getLoginUserName();
            title = title.replace("undefined", loginUserName);
            payload.setTitle(title);
        }
        if (payload.getDescription() != null && payload.getDescription().contains("undefined")) {
            String description = payload.getDescription();
            loginUserName = GlobalUtil.getLoginUserName();
            description = description.replace("undefined", loginUserName);
            payload.setDescription(description);
        }
        boolean isNew = payload.getId() == null;
        PrdCalendarDO ado = PrdCalendarConvert.INSTANCE.toDo(payload);
        if (ado.getDefaultFlag() == null) {
            ado.setDefaultFlag(0);
        }
        ado = this.dao.save(ado);
        payload.setId(ado.getId());
        payload.setCreateUserId(ado.getCreateUserId());
        List shares = payload.getShares();
        Long calId = ado.getId();
        List<PrdCalendarShareVO> prdCalendarShareVOS = this.calendarShareDAO.queryByCalId(calId);
        if (shares != null && !shares.isEmpty() && !payload.getSkipShares().booleanValue()) {
            boolean b;
            for (PrdCalendarSharePayload share : shares) {
                b = prdCalendarShareVOS.stream().anyMatch(m -> m.getUserId().equals(share.getUserId()));
                if (b) continue;
                share.setCalId(calId);
                PrdCalendarShareDO shareDO = PrdCalendarShareConvert.INSTANCE.toDo(share);
                this.calendarShareDAO.save(shareDO);
            }
            for (PrdCalendarShareVO shareVO : prdCalendarShareVOS) {
                b = shares.stream().anyMatch(m -> m.getUserId().equals(shareVO.getUserId()));
                ArrayList<Long> ids = new ArrayList<Long>();
                if (!b) {
                    ids.add(shareVO.getId());
                }
                if (ids.isEmpty()) continue;
                this.calendarShareDAO.deleteSoft(ids);
            }
        } else {
            List<Long> collect = prdCalendarShareVOS.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.calendarShareDAO.deleteSoft(collect);
        }
        if (payload.getFromQyWx() == null || !payload.getFromQyWx().booleanValue()) {
            if (isNew) {
                String qywxCalId = this.wxService.saveCalendar(this.transferToQyWxPayload(payload));
                ado.setQyWxCalId(qywxCalId);
                this.dao.save(ado);
            } else {
                PrdCalendarVO prdCalendarVO = this.dao.queryByKey(payload.getId());
                payload.setCreateUserId(prdCalendarVO.getCreateUserId());
                payload.setQyWxCalId(prdCalendarVO.getQyWxCalId());
                this.wxService.updateCalendar(this.transferToQyWxPayload(payload));
            }
        }
        return PrdCalendarConvert.INSTANCE.toVo(ado);
    }

    public QyWxCalendarPayload transferToQyWxPayload(PrdCalendarPayload calendarPayload) {
        QyWxCalendarPayload payload = new QyWxCalendarPayload();
        payload.setCal_id(calendarPayload.getQyWxCalId());
        payload.setSummary(calendarPayload.getTitle());
        payload.setDescription(calendarPayload.getDescription());
        payload.setReadonly(calendarPayload.getReadonly());
        payload.setSet_as_default(calendarPayload.getDefaultFlag());
        Long createUserId = calendarPayload.getCreateUserId();
        String weComId = this.getWeComId(createUserId);
        payload.setOrganizer(weComId);
        ArrayList<QyWxCalendarSharePayload> qyWxShares = new ArrayList<QyWxCalendarSharePayload>();
        List shares = calendarPayload.getShares();
        if (shares != null && !shares.isEmpty()) {
            for (PrdCalendarSharePayload share : shares) {
                QyWxCalendarSharePayload qyWxShare = new QyWxCalendarSharePayload();
                qyWxShare.setReadonly(share.getReadonly());
                Long userId = share.getUserId();
                qyWxShare.setUserid(this.getWeComId(userId));
                qyWxShares.add(qyWxShare);
            }
        }
        payload.setShares(qyWxShares);
        payload.setColor(calendarPayload.getColor());
        return payload;
    }

    public PrdCalendarPayload transferToPrdPayload(QyWxCalendarPayload calendarPayload) {
        PrdCalendarPayload payload = new PrdCalendarPayload();
        payload.setQyWxCalId(calendarPayload.getCal_id());
        payload.setTitle(calendarPayload.getSummary());
        payload.setDescription(calendarPayload.getDescription());
        payload.setReadonly(calendarPayload.getReadonly());
        payload.setDefaultFlag(calendarPayload.getSet_as_default());
        Long createUserId = this.getUserIdByWeComId(calendarPayload.getOrganizer());
        payload.setCreateUserId(createUserId);
        ArrayList<PrdCalendarSharePayload> prdShares = new ArrayList<PrdCalendarSharePayload>();
        List shares = calendarPayload.getShares();
        if (shares != null && !shares.isEmpty()) {
            List shares1 = JSON.parseArray((String)String.valueOf(shares), QyWxCalendarSharePayload.class);
            for (QyWxCalendarSharePayload share : shares1) {
                PrdCalendarSharePayload prdShare = new PrdCalendarSharePayload();
                prdShare.setReadonly(share.getReadonly());
                Long userId = this.getUserIdByWeComId(share.getUserid());
                prdShare.setUserId(userId);
                prdShares.add(prdShare);
            }
        }
        payload.setShares(prdShares);
        payload.setColor(calendarPayload.getColor());
        return payload;
    }

    public List<PrdCalendarVO> queryList(PrdCalendarQuery query) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long id = userDetails == null ? 0L : userDetails.getUser().getId();
        List<PrdCalendarVO> prdCalendarVOS = this.dao.queryByCreateUserId(id);
        List calIdsByCreateUserId = prdCalendarVOS.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        List<PrdCalendarShareVO> prdCalendarShareVOS = this.calendarShareDAO.queryByUserId(id);
        List calIdsByShares = prdCalendarShareVOS.stream().map(item -> item.getCalId()).distinct().collect(Collectors.toList());
        calIdsByShares.addAll(calIdsByCreateUserId);
        List collect = calIdsByShares.stream().distinct().collect(Collectors.toList());
        query.setCalIds(collect);
        return this.dao.queryListDynamic(query);
    }

    @Transactional
    public void deleteSoft(List<Long> asList) {
        for (Long calendarId : asList) {
            PrdCalendarVO prdCalendarVO = this.dao.queryByKey(calendarId);
            String qyWxCalId = prdCalendarVO.getQyWxCalId();
            if (qyWxCalId == null) continue;
            this.wxService.deleteCalendar(qyWxCalId);
        }
        this.dao.deleteSoft(asList);
    }

    public PrdCalendarVO queryDetail(Long id) {
        PrdCalendarVO prdCalendarVO = this.dao.queryByKey(id);
        if (prdCalendarVO != null) {
            List<Object> shares = this.calendarShareDAO.queryByCalId(prdCalendarVO.getId());
            shares = shares.stream().filter(item -> !item.getUserId().equals(prdCalendarVO.getCreateUserId())).collect(Collectors.toList());
            prdCalendarVO.setShares(shares);
        }
        return prdCalendarVO;
    }

    public String getWeComId(Long userId) {
        return "";
    }

    public Long getUserIdByWeComId(String userid) {
        PrdOrgEmployeeDO employeeDO = this.employeeDAO.queryByWeComeId(userid);
        if (employeeDO == null) {
            throw TwException.error("", "\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u5230\u672c\u5730\u5931\u8d25\uff01");
        }
        Long userId = employeeDO.getUserId();
        if (userId == null) {
            throw TwException.error("", "\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u5230\u672c\u5730\u5931\u8d25\uff01");
        }
        return userId;
    }

    public PrdCalendarServiceImpl(PrdCalendarDAO dao, PrdCalendarShareDAO calendarShareDAO, QyWxCommunicationService wxService, PrdOrgEmployeeDAO employeeDAO) {
        this.dao = dao;
        this.calendarShareDAO = calendarShareDAO;
        this.wxService = wxService;
        this.employeeDAO = employeeDAO;
    }
}

