/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdTemporaryStorageService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdTemporaryStorageVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdTemporaryStorageConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdTemporaryStorageDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdTemporaryStorageDO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PrdTemporaryStorageServiceImpl
implements PrdTemporaryStorageService {
    private static final Logger log = LoggerFactory.getLogger(PrdTemporaryStorageServiceImpl.class);
    private final PrdTemporaryStorageDAO dao;

    public PrdTemporaryStorageVO saveOne(PrdTemporaryStoragePayload payload) {
        PrdTemporaryStorageDO ado = PrdTemporaryStorageConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        return PrdTemporaryStorageConvert.INSTANCE.toVo(ado);
    }

    public void dynamicUpdate(PrdTemporaryStoragePayload payload) {
        this.dao.updateByKeyDynamic(payload);
    }

    public List<PrdTemporaryStorageVO> queryList(PrdTemporaryStorageQuery query) {
        Specification<PrdTemporaryStorageDO> spec = this.dao.getSpec(query);
        List<PrdTemporaryStorageDO> all = this.dao.findAll(spec);
        return all.stream().map(e -> PrdTemporaryStorageConvert.INSTANCE.toVo((PrdTemporaryStorageDO)((Object)e))).collect(Collectors.toList());
    }

    public Object paging(PrdTemporaryStorageQuery query) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        query.setCreateUserId(userId);
        Specification<PrdTemporaryStorageDO> spec = this.dao.getSpec(query);
        Page<PrdTemporaryStorageDO> all = this.dao.findAll(spec, (Pageable)query.getPageRequest());
        List content = all.getContent();
        List collect = content.stream().map(e -> PrdTemporaryStorageConvert.INSTANCE.toVo((PrdTemporaryStorageDO)((Object)e))).collect(Collectors.toList());
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    public PrdTemporaryStorageVO queryDetail(Long id) {
        PrdTemporaryStorageDO detail = this.dao.queryById(id);
        PrdTemporaryStorageVO temporaryStorageVO = PrdTemporaryStorageConvert.INSTANCE.toVo(detail);
        return temporaryStorageVO;
    }

    public void deleteTemporaryStorageSoft(List<Long> storageIds) {
        this.dao.deleteSoft(storageIds);
    }

    public PrdTemporaryStorageServiceImpl(PrdTemporaryStorageDAO dao) {
        this.dao = dao;
    }
}

