/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.tianyancha.service;

import cn.hutool.http.HttpUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.tianyancha.config.TianYanChaProperties;
import com.elitesland.tw.tw5.server.prd.tianyancha.service.TianYanChaService;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class TianYanChaServiceImpl
implements TianYanChaService {
    private static final Logger log = LoggerFactory.getLogger(TianYanChaServiceImpl.class);
    private final TianYanChaProperties tianYanChaProperties;
    private final ApiRequestLogService apiRequestLogService;

    @Override
    public String getMessageByUrlToken(String path) {
        String result = "";
        Object status = "";
        long start = System.currentTimeMillis();
        try {
            HttpGet request = new HttpGet(path);
            request.setHeader("Authorization", this.tianYanChaProperties.getToken());
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            } else {
                log.error("\u8c03\u7528\u5929\u773c\u67e5\u63a5\u53e3\u5f02\u5e38\uff0cpath:{}; result:{};", (Object)path, (Object)result);
            }
            status = "" + response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            result = e.getMessage();
            log.error("\u8c03\u7528\u5929\u773c\u67e5\u63a5\u53e3\u5f02\u5e38\uff0cpath:{}; ", (Object)path, (Object)e);
        }
        long time = System.currentTimeMillis() - start;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.TYC, path, RequestMethod.GET, null, "Authorization:" + this.tianYanChaProperties.getToken(), result, (String)status, time);
        return result;
    }

    @Override
    public String search(String word, Integer pageSize, Integer pageNum) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("word", word);
        if (null != pageSize) {
            param.put("pageSize", pageSize);
        }
        if (null != pageNum) {
            param.put("pageNum", pageNum);
        }
        String uri = HttpUtil.urlWithForm((String)this.tianYanChaProperties.getUriSearch(), param, null, (boolean)true);
        return this.getMessageByUrlToken(uri);
    }

    public TianYanChaServiceImpl(TianYanChaProperties tianYanChaProperties, ApiRequestLogService apiRequestLogService) {
        this.tianYanChaProperties = tianYanChaProperties;
        this.apiRequestLogService = apiRequestLogService;
    }
}

