/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.udc;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.udc.UdcDTO;
import com.elitesland.tw.tw5.server.udc.UdcTypeEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UdcUtil {
    private static final Logger log = LoggerFactory.getLogger(UdcUtil.class);
    private final CacheUtil cacheUtil;
    private static final String COLLECTION_FIELD_TYPE = "Collection";

    public Object translate(Object result) {
        Object obj;
        if (result instanceof List || result instanceof ArrayList) {
            List olist = (List)result;
            if (olist.size() == 0) {
                return result;
            }
            obj = olist.get(0);
        } else {
            obj = result;
        }
        List<UdcDTO> udcParams = this.getUdcMapping(result, obj.getClass(), null, null);
        if (udcParams.size() == 0) {
            return result;
        }
        if (result instanceof List || result instanceof ArrayList) {
            for (Object entity : (List)result) {
                this.assign(entity, udcParams);
            }
        } else {
            this.assign(result, udcParams);
        }
        return result;
    }

    public List translateList(List result) {
        if (result.size() == 0) {
            return result;
        }
        Object obj = result.get(0);
        List<UdcDTO> udcParams = this.getUdcMapping(obj, obj.getClass(), null, null);
        if (udcParams.size() == 0) {
            return result;
        }
        for (Object entity : result) {
            this.assign(entity, udcParams);
        }
        return result;
    }

    public Object translateReverse(Object result) {
        Object obj;
        if (result instanceof List || result instanceof ArrayList) {
            List olist = (List)result;
            if (olist.size() == 0) {
                return result;
            }
            obj = olist.get(0);
        } else {
            obj = result;
        }
        List<UdcDTO> udcParams = this.getUdcMapping(obj, obj.getClass(), null, null);
        if (udcParams.size() == 0) {
            return result;
        }
        if (result instanceof List || result instanceof ArrayList) {
            for (Object entity : (List)result) {
                this.assignReverse(entity, udcParams);
            }
        } else {
            this.assignReverse(result, udcParams);
        }
        return result;
    }

    public List translateListReverse(List result) {
        if (result.size() == 0) {
            return result;
        }
        Object obj = result.get(0);
        List<UdcDTO> udcParams = this.getUdcMapping(obj, obj.getClass(), null, null);
        if (udcParams.size() == 0) {
            return result;
        }
        for (Object entity : result) {
            this.assignReverse(entity, udcParams);
        }
        return result;
    }

    public void assign(Object entity, List<UdcDTO> dictParams) {
        List listTypeUdc = dictParams.stream().filter(udcDTO -> StringUtils.hasText((String)udcDTO.getType()) && udcDTO.getType().equals(COLLECTION_FIELD_TYPE)).collect(Collectors.toList());
        List listFieldKeys = listTypeUdc.stream().map(UdcDTO::getListFieldName).distinct().collect(Collectors.toList());
        for (String listFieldKey : listFieldKeys) {
            try {
                Class<?> c = entity.getClass();
                if (c == null) continue;
                Field f = c.getDeclaredField(listFieldKey);
                f.setAccessible(true);
                Object preValue = f.get(entity);
                if (!ObjectUtil.isNotNull((Object)preValue)) continue;
                Collection list = (Collection)preValue;
                for (Object obj : list) {
                    for (UdcDTO dictParam : listTypeUdc) {
                        this.translation(obj, dictParam);
                    }
                }
                f.set(entity, list);
            }
            catch (Exception e) {
                log.error("[UDC\u7ffb\u8bd1\u5f02\u5e38]:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        List generalTypeUdc = dictParams.stream().filter(udcDTO -> !StringUtils.hasText((String)udcDTO.getType()) || !StringUtils.hasText((String)udcDTO.getListFieldName())).collect(Collectors.toList());
        for (UdcDTO dictParam : generalTypeUdc) {
            this.translation(entity, dictParam);
        }
    }

    private void translation(Object entity, UdcDTO dictParam) {
        String selectionKey = dictParam.getUdcName();
        String codePropName = dictParam.getCodePropName();
        String filedName = dictParam.getFieldName();
        try {
            Class<?> c = entity.getClass();
            if (c != null) {
                Field f = c.getDeclaredField(codePropName);
                f.setAccessible(true);
                Object preValue = f.get(entity);
                if (ObjectUtil.isNotNull((Object)preValue)) {
                    Field fValue = c.getDeclaredField(filedName);
                    fValue.setAccessible(true);
                    String preValueStr = preValue.toString();
                    String[] preValueStrArr = preValueStr.split(",");
                    if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                        ArrayList<String> valueDescArr = new ArrayList<String>();
                        for (String s : preValueStrArr) {
                            String userName = this.cacheUtil.getUserName(Long.valueOf(s));
                            valueDescArr.add(userName);
                        }
                        fValue.set(entity, valueDescArr.stream().collect(Collectors.joining(",")));
                    } else if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                        ArrayList<String> valueDescArr = new ArrayList<String>();
                        for (String s : preValueStrArr) {
                            String orgName = this.cacheUtil.getOrgName(Long.valueOf(s));
                            valueDescArr.add(orgName);
                        }
                        fValue.set(entity, valueDescArr.stream().collect(Collectors.joining(",")));
                    } else {
                        fValue.set(entity, this.cacheUtil.transferSystemSelection(selectionKey, preValueStr));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("[UDC\u7ffb\u8bd1\u5f02\u5e38]:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void assignReverse(Object entity, List<UdcDTO> dictParams) {
        for (UdcDTO dictParam : dictParams) {
            String selectionKey = dictParam.getUdcName();
            String codePropName = dictParam.getCodePropName();
            String filedName = dictParam.getFieldName();
            try {
                Class<?> c = entity.getClass();
                if (c == null) continue;
                Field f = c.getDeclaredField(filedName);
                f.setAccessible(true);
                Object preValue = f.get(entity);
                if (!ObjectUtil.isNotNull((Object)preValue)) continue;
                Field fValue = c.getDeclaredField(codePropName);
                fValue.setAccessible(true);
                if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                    fValue.set(entity, (long)this.cacheUtil.getUserIdByName(preValue.toString()));
                    continue;
                }
                if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                    fValue.set(entity, (long)this.cacheUtil.getOrgIdByOrgName(preValue.toString()));
                    continue;
                }
                fValue.set(entity, this.cacheUtil.getSystemSelectionValueByName(selectionKey, preValue.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<UdcDTO> getUdcMapping(Object entity, Class cla, String listFieldName, String fieldType) {
        Field[] fields = cla.getDeclaredFields();
        ArrayList<UdcDTO> list = new ArrayList<UdcDTO>();
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (Collection.class.isAssignableFrom(type)) {
                String name = field.getName();
                try {
                    List olist;
                    Field f = cla.getDeclaredField(name);
                    f.setAccessible(true);
                    Object obj = f.get(entity);
                    if (null != obj && obj instanceof List && (olist = (List)obj).size() > 0) {
                        obj = olist.get(0);
                        Class<?> aClass = obj.getClass();
                        list.addAll(this.getUdcMapping(obj, aClass, name, COLLECTION_FIELD_TYPE));
                    }
                }
                catch (Exception e) {
                    log.error("UDC \u7ffb\u8bd1\u5f02\u5e38-\u5b50\u96c6\u5408\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (!field.isAnnotationPresent(UdcName.class)) continue;
            UdcName udcName = field.getAnnotation(UdcName.class);
            UdcDTO udcDto = new UdcDTO(udcName.udcName(), udcName.codePropName(), field.getName());
            udcDto.setListFieldName(listFieldName);
            udcDto.setType(fieldType);
            list.add(udcDto);
        }
        return list;
    }

    public UdcUtil(CacheUtil cacheUtil) {
        this.cacheUtil = cacheUtil;
    }
}

