package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务对象字段明细
 *
 * @folder 页面配置
 * @author duwh
 * @date 2023-06-14
 */
@Api(tags = "业务对象字段明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessTableFields")
@Slf4j
public class BusinessTableFieldsController {

private final BusinessTableFieldsService businessTableFieldsService;

    /**
     * 业务对象字段明细-新增
     *
     * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务对象字段明细-新增")
    public TwOutputUtil<BusinessTableFieldsVO> insert(@RequestBody BusinessTableFieldsPayload payload){
         return TwOutputUtil.ok(businessTableFieldsService.insert(payload));
    }

    /**
     * 业务对象字段明细-更新
     *
         * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务对象字段明细-更新")
    public TwOutputUtil<BusinessTableFieldsVO> update(@RequestBody BusinessTableFieldsPayload payload){
        return TwOutputUtil.ok(businessTableFieldsService.update(payload));
    }

    /**
     * 业务对象字段明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 页面配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("业务对象字段明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessTableFieldsPayload payload){
        return TwOutputUtil.ok(businessTableFieldsService.updateByKeyDynamic(payload));
    }

    /**
     * 业务对象字段明细-主键查询
     *
     * @folder 页面配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-主键查询")
    public TwOutputUtil<BusinessTableFieldsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTableFieldsService.queryByKey(key));
    }

    /**
     * 业务对象字段明细-分页
     *
         * @folder 页面配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-分页")
    public TwOutputUtil<PagingVO<BusinessTableFieldsVO>> paging(BusinessTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryPaging(query));
    }

    /**
     * 业务对象字段明细-查询列表
     *
     * @folder 页面配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-查询列表")
    public TwOutputUtil<List<BusinessTableFieldsVO>> queryList(BusinessTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryListDynamic(query));
    }

    /**
     * 业务对象字段明细-删除
     *
         * @folder 页面配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务对象字段明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessTableFieldsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

