package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
@Entity
@Table(name = "prd_business_table_fields", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_table_fields", comment = "业务对象字段明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessTableFieldsDO extends BaseModel implements Serializable  {

    /** 业务对象主表主键 prd_business_table.id */
    @Comment("业务对象主表主键 prd_business_table.id")
    @Column()
    private String tableId;
    /** 字段 */
    @Comment("字段")
    @Column()
    private String field;
    /** 字段类型(数据库) */
    @Comment("字段类型(数据库)")
    @Column()
    private String type;
    /** 字段key */
    @Comment("字段key")
    @Column()
    private String fieldKey;
    /** 字段名称 */
    @Comment("字段名称")
    @Column()
    private String fieldName;
    /** 是否业务字段 */
    @Comment("是否业务字段")
    @Column()
    private Boolean businessFlag;
    /** 是否必填 */
    @Comment("是否必填")
    @Column()
    private Boolean notNull;
    /** 显示名称 */
    @Comment("显示名称")
    @Column()
    private String showName;
    /** 业务类型 INPUT 文本输入 SELECT 选择器 */
    @Comment("业务类型 INPUT 文本输入 SELECT 选择器")
    @Column()
    private String showType;
    /** 业务属性 JSON格式 */
    @Comment("业务属性 JSON格式")
    @Column()
    private String showAttr;
    /** 默认值 */
    @Comment("默认值")
    @Column()
    private String defalutValue;
    /** 正则验证 */
    @Comment("正则验证")
    @Column()
    private String regexVerify;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessTableFieldsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
