package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableFieldsRepo;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableFieldsDAO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableFieldsConvert;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableFieldsDO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableFieldsConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessTableFieldsServiceImpl extends BaseServiceImpl implements BusinessTableFieldsService {

    private final BusinessTableFieldsRepo businessTableFieldsRepo;
    private final BusinessTableFieldsDAO businessTableFieldsDAO;

    @Override
    public PagingVO<BusinessTableFieldsVO> queryPaging(BusinessTableFieldsQuery query){
        return businessTableFieldsDAO.queryPaging(query);
    }

    @Override
    public List<BusinessTableFieldsVO> queryListDynamic(BusinessTableFieldsQuery query){
        return businessTableFieldsDAO.queryListDynamic(query);
    }

    @Override
    public BusinessTableFieldsVO queryByKey(Long key) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(key).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableFieldsVO vo = BusinessTableFieldsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableFieldsVO insert(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        return BusinessTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableFieldsVO update(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessTableFieldsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<BusinessTableFieldsDO> optional = businessTableFieldsRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessTableFieldsDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    businessTableFieldsRepo.save(entity);
                }
             });
        }
    }

}
