package com.elitesland.tw.tw5.server.common.util;


import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.ObjectUtils;


import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author zoey
 * @Description: 两个简单集合比较，确定新增和删除列表
 * @date 2023/2/23 - 11:49
 */
public class ListCompareUtil {
    /**
     * 比较两个集合，获取需要增加的集合列表
     * 目标集合【历史数据】中没有源集合【新数据】中的数据时，需新增
     * orginList存在而targetList不存在的数据
     * @param orginList
     * @param targetList
     * @param <E>
     * @return
     */
    public static <E> List<E> getInsertList(List<E> orginList,List<E> targetList){
        List<E> insertList = new ArrayList<>();
        orginList.stream().forEach(o ->{
            if (!isContain(targetList,o)){
                insertList.add(o);
            }
        });
        return insertList;
    }

    /**
     * 比较两个集合，获取需要删除的集合列表
     * 源集合【新数据】中没有目标集合【历史数据】中的数据时，需从【历史数据】中删除
     * orginList不存在而targetList中存在的数据
     * @param orginList
     * @param targetList
     * @param <E>
     * @return
     */
    public static <E> List<E> getDeleteList(List<E> orginList,List<E> targetList){
        List<E> deleteList = new ArrayList<>();
        targetList.stream().forEach( t ->{
            if (!isContain(orginList,t)){
                deleteList.add(t);
            }
        });
        return deleteList;
    }

    /**
     * 判断集合中是否包含某元素
     * @param list 元素列表
     * @param t  待判断的元素
     * @param <E>
     * @return  包含为true，不包含为false
     */
    private static <E> boolean isContain(List<E> list, E t){
        AtomicBoolean flag = new AtomicBoolean(false);
        if (CollectionUtils.isEmpty(list) || ObjectUtils.isEmpty(t)){
            flag.set(false);
        }
        list.stream().forEach(i ->{
            if (i.equals(t)){
                flag.set(true);
            }
        });
        return flag.get();
    }

}
