package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgSyncLogRepo;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

@Repository
@RequiredArgsConstructor
public class PrdOrgSyncLogDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgSyncLogRepo repo;
    private final QPrdOrgSyncLogDO qdo = QPrdOrgSyncLogDO.prdOrgSyncLogDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgSyncLogDO save(PrdOrgSyncLogDO ado) {
        return repo.save(ado);
    }


    /**
     * 查询最新同步记录
     *
     * @param syncType
     * @return 结果
     */
    public LocalDateTime queryOrgSyncLog(String syncType) {
        JPAQuery<LocalDateTime> jpaQuery = jpaQueryFactory.select(qdo.createTime).from(qdo);
        jpaQuery.where(qdo.syncType.eq(syncType));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, null)).offset(0).limit(1);
        return jpaQuery.fetchFirst();
    }


}
