/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAddressPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAddressService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbAddressConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbAddressDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdAbAddressServiceImpl
implements PrdAbAddressService {
    private static final Logger log = LoggerFactory.getLogger(PrdAbAddressServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdAbAddressDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.address.operation}")
    private String address_operation;
    @Value(value="${tw4.address.del}")
    private String address_del;

    @Transactional
    public PrdAbAddressVO save(PrdAbAddressPayload payload) {
        if (payload.getDefaultAddress() != null && payload.getDefaultAddress().booleanValue()) {
            Long bookId = payload.getBookId();
            List<PrdAbAddressVO> prdAbAddressVOS = this.queryList(bookId);
            for (PrdAbAddressVO prdAbAddressVO : prdAbAddressVOS) {
                if (prdAbAddressVO.getDefaultAddress() == null || !prdAbAddressVO.getDefaultAddress().booleanValue()) continue;
                PrdAbAddressPayload prdAbAddressPayload = PrdAbAddressConvert.INSTANCE.toPayload(prdAbAddressVO);
                prdAbAddressPayload.setDefaultAddress(Boolean.valueOf(false));
                prdAbAddressPayload.setObjectType("customer");
                this.update(prdAbAddressPayload);
            }
        }
        PrdAbAddressDO contactsDO = PrdAbAddressConvert.INSTANCE.toDo(payload);
        contactsDO = this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbAddressConvert.INSTANCE.toVo(contactsDO);
    }

    void saveBaseLog(Long bookId, String objectType, String logType) {
    }

    @Transactional
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        this.dao.delete(keys);
        this.saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    public boolean update(PrdAbAddressPayload payload) {
        PrdAbAddressDO contactsDO = PrdAbAddressConvert.INSTANCE.toDo(payload);
        if (payload.getDefaultAddress() != null && payload.getDefaultAddress().booleanValue()) {
            Long bookId = payload.getBookId();
            List<PrdAbAddressVO> prdAbAddressVOS = this.queryList(bookId);
            for (PrdAbAddressVO prdAbAddressVO : prdAbAddressVOS) {
                if (prdAbAddressVO.getDefaultAddress() == null || !prdAbAddressVO.getDefaultAddress().booleanValue()) continue;
                PrdAbAddressPayload prdAbAddressPayload = PrdAbAddressConvert.INSTANCE.toPayload(prdAbAddressVO);
                prdAbAddressPayload.setDefaultAddress(Boolean.valueOf(false));
                prdAbAddressPayload.setObjectType("customer");
                this.update(prdAbAddressPayload);
            }
        }
        this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    public List<PrdAbAddressVO> queryList(Long bookId) {
        List<PrdAbAddressVO> contactsVOS = this.dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbAddressVO)contactsVO));
        return contactsVOS;
    }

    public List<PrdAbAddressVO> queryList(Long bookId, String addressType) {
        List<PrdAbAddressVO> contactsVOS = this.dao.queryList(bookId, addressType);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbAddressVO)contactsVO));
        return contactsVOS;
    }

    void transferSystemSelection(PrdAbAddressVO vo) {
        vo.setAddressTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbAddressType.getCode(), vo.getAddressType()));
        vo.setCountryName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCountry.getCode(), vo.getCountry()));
    }

    public PrdAbAddressServiceImpl(CacheUtil cacheUtil, PrdAbAddressDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

