package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 页面配置
 *
 * @author duwh
 * @date 2023-06-20
 */
@Entity
@Table(name = "business_page", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_page", comment = "页面配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessPageDO extends BaseModel implements Serializable  {
    /** 名称 */
    @Comment("名称")
    @Column()
    private String name;
    /** 编码 */
    @Comment("编码")
    @Column()
    private String code;
    /** 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟) */
    @Comment("类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟)")
    @Column()
    private String type;
    /** 功能主键 prd_system_function.id */
    @Comment("功能主键 prd_system_function.id")
    @Column()
    private Long functionId;
    /** 页面配置json内容 */
    @Comment("页面配置json内容")
    @Column(name = "json_content", columnDefinition = "longtext")
    private String jsonContent;
    /** 是否启用 true/1 启用 false/0 不启用 */
    @Comment("是否启用 true/1 启用 false/0 不启用")
    @Column()
    private Boolean enabled;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessPageDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
