package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleRepeatVO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdScheduleRepeatDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdScheduleRepeatRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/21 - 14:22
 */
@Repository
@RequiredArgsConstructor
public class PrdScheduleRepeatDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdScheduleRepeatRepo repo;
    private final QPrdScheduleRepeatDO qdo = QPrdScheduleRepeatDO.prdScheduleRepeatDO;


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdScheduleRepeatDO save(PrdScheduleRepeatDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<PrdScheduleRepeatVO> getJpaQuerySelect() {
        JPAQuery<PrdScheduleRepeatVO> jpaQuery=jpaQueryFactory.select(Projections.bean(PrdScheduleRepeatVO.class,
                qdo.id,
                qdo.secheduleId,
                qdo.repeatType,
                qdo.repeatUntil,
                qdo.isCustomRepeat,
                qdo.repeatInterval,
                qdo.repeatDayOfWeek,
                qdo.repeatDayOfMonth,
                qdo.exdate
        )).from(qdo);
        return jpaQuery;
    }


    public PrdScheduleRepeatVO queryByScheduleId(Long scheduleId) {
        JPAQuery<PrdScheduleRepeatVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.secheduleId.eq(scheduleId));
        return jpaQuery.fetchFirst();
    }



    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdScheduleRepeatPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getExdate() != null) {
            update.set(qdo.exdate, payload.getExdate());
        }
        if (payload.getRepeatUntil() !=null){
            update.set(qdo.repeatUntil,payload.getRepeatUntil());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

        }
        // 执行修改
        return update.execute();
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }




}
