/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationDataPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ec4\u7ec7\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/org"})
public class PrdOrgOrganizationController {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgOrganizationController.class);
    private final PrdOrgOrganizationService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/org/insert"})
    public TwOutputUtil insert(PrdOrgOrganizationPayload entity) {
        PrdOrgOrganizationVO vo = this.service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/org/update"})
    public TwOutputUtil update(PrdOrgOrganizationPayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/org/updateStatus"})
    public TwOutputUtil updateStatus(Long id, String orgStatus) {
        this.service.updateStatus(id, orgStatus);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5168\u5c40\u4fee\u6539\u7ec4\u7ec7\u6811\u4fee\u5173\u7cfb")
    @PutMapping(value={"/org/updateAllRef"})
    public TwOutputUtil updateAllRef(String payloadStrs) {
        this.service.updateOrgOrEmpRef(JSONObject.parseArray((String)payloadStrs, PrdOrgOrganizationDataPayload.class));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u7236\u7ec4\u7ec7")
    @PutMapping(value={"/org/updateRef"})
    public TwOutputUtil updateRef(PrdOrgOrganizationRefPayload payload) {
        this.service.updateRef(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7ec4\u7ec7\u5f15\u7528")
    @PutMapping(value={"/org/reference"})
    public TwOutputUtil reference(PrdOrgOrganizationRefPayload payload) {
        this.service.reference(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7ec4\u7ec7\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/org/delete"})
    public TwOutputUtil delete(Long dimensionId, Long orgId) {
        this.service.deleteSoft(dimensionId, orgId);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6id\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/org/list"})
    public TwOutputUtil queryList(Long dimensionId) {
        List vo = this.service.queryList(dimensionId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/org/pading"})
    public TwOutputUtil queryPading(PrdOrgOrganizationQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u5458\u5de5")
    @GetMapping(value={"/org/queryEmployeeRefList"})
    public TwOutputUtil queryEmployeeRefList(Long orgId) {
        List vo = this.service.queryEmployeeRefList(orgId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u53ef\u7528\u7ec4\u7ec7")
    @GetMapping(value={"/org/queryAll"})
    public TwOutputUtil queryAll(Long dimensionId, Boolean defaultFlag) {
        List vo = this.service.queryAll(dimensionId, defaultFlag);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u548c\u7ef4\u5ea6\u7ec4\u7ec7\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/org/detail"})
    public TwOutputUtil queryDetail(Long dimensionId, Long orgId) {
        PrdOrgOrganizationVO vo = this.service.queryDetail(dimensionId, orgId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u5458\u5de5")
    @PostMapping(value={"/org/insertEmployee"})
    public TwOutputUtil insertEmployeeRef(String payloadStrs) {
        this.service.insertEmployeeRef(JSONObject.parseArray((String)payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u79fb\u9664\u7ec4\u7ec7\u5458\u5de5")
    @PutMapping(value={"/org/deleteEmployee"})
    public TwOutputUtil deleteEmployee(Long orgId, Long[] userIds) {
        this.service.deleteEmployeeRefSoft(orgId, Arrays.asList(userIds));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u89d2\u8272")
    @PutMapping(value={"/org/updateRole"})
    public TwOutputUtil updateRole(PrdOrgRolePayload payload) {
        this.service.updateRole(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u89d2\u8272")
    @DeleteMapping(value={"/org/deleteRole/{key}"})
    public TwOutputUtil deleteRoleSoft(@PathVariable Long key) {
        this.service.deleteRoleSoft(key);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/org/syncFromV4"})
    public TwOutputUtil syncFromV4(@RequestBody List<PrdOrgOrganizationPayload> orgOrganizationPayloads) {
        System.out.println(orgOrganizationPayloads);
        return TwOutputUtil.ok(log);
    }

    public PrdOrgOrganizationController(PrdOrgOrganizationService service) {
        this.service = service;
    }
}

