/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdOrgCompanyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgCompanyRepo repo;
    private final QPrdOrgCompanyDO qdo = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;

    private JPAQuery<PrdOrgCompanyVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgCompanyVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdoAb.bookNo.as("companyNo"), this.qdo.companyName, this.qdo.companyIndustry, this.qdo.companyPhone, this.qdo.companyEmail, this.qdo.companyAddress, this.qdo.companyWebsite, this.qdo.companyScale, this.qdo.taxNo, this.qdo.currency, this.qdo.language, this.qdo.companyNature})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdo.bookId.longValue().eq((Expression)this.qdoAb.id.longValue()));
        return jpaQuery;
    }

    public List<PrdOrgCompanyVO> queryList(String relateType) {
        JPAQuery<PrdOrgCompanyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdoAb.bookType.eq((Object)SystemDefaultEnum.DefaultAbType.getCode()));
        jpaQuery.where((Predicate)this.qdoAb.relateType.contains(relateType));
        jpaQuery.where((Predicate)this.qdoAb.deleteFlag.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, null));
        return jpaQuery.fetch();
    }

    public String queryNameByKey(Long key) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.companyName).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoAb.deleteFlag.eq((Object)0));
        return (String)jpaQuery.fetchFirst();
    }

    public PrdOrgCompanyDAO(JPAQueryFactory jpaQueryFactory, PrdOrgCompanyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

