/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.shorturl.controller;

import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRequestLogService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags={"\u77ed\u94fe"})
@Controller
@RequestMapping(value={"/s"})
public class ShortUrlRedirectController {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlRedirectController.class);
    private final ShortUrlRefService shortUrlRefService;
    private final ShortUrlRequestLogService shortUrlRequestLogService;

    @GetMapping(value={"r/{code}"})
    @ApiOperation(value="\u77ed\u94fe-\u77ed\u94fe\u91cd\u5b9a\u5411")
    public void redirect(@PathVariable String code, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ShortUrlRefVO shortUrlRefVO = this.shortUrlRefService.queryByCodeAndAddVisitNum(code);
        if (null == shortUrlRefVO) {
            this.shortUrlRequestLogService.log(shortUrlRefVO, request);
            return;
        }
        this.shortUrlRequestLogService.log(shortUrlRefVO, request);
        String longUrl = shortUrlRefVO.getLongUrl();
        if (StringUtils.hasText((String)longUrl)) {
            log.info("URL:{} ,\u91cd\u5b9a\u5411redirect URL:{}", (Object)shortUrlRefVO.getShortUrl(), (Object)longUrl);
            response.setHeader("Location", longUrl);
            response.setStatus(302);
            response.sendRedirect(longUrl);
        }
    }

    @GetMapping(value={"f/{code}"})
    @ApiOperation(value="\u77ed\u94fe-\u77ed\u94fe\u8f6c\u53d1")
    public String forward(@PathVariable String code, HttpServletResponse response) {
        ShortUrlRefVO shortUrlRefVO = this.shortUrlRefService.queryByCodeAndAddVisitNum(code);
        if (null == shortUrlRefVO) {
            return null;
        }
        String longUrl = shortUrlRefVO.getLongUrl();
        if (StringUtils.hasText((String)longUrl)) {
            log.info("URL:{} ,\u8f6c\u53d1redirect URL:{}", (Object)shortUrlRefVO.getShortUrl(), (Object)longUrl);
            return "forword:" + longUrl;
        }
        return null;
    }

    public ShortUrlRedirectController(ShortUrlRefService shortUrlRefService, ShortUrlRequestLogService shortUrlRequestLogService) {
        this.shortUrlRefService = shortUrlRefService;
        this.shortUrlRequestLogService = shortUrlRequestLogService;
    }
}

