/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdFsmFileRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdFsmFileRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdFsmFileRefConvert;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdFsmFileRefDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdFsmFileRefRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdFsmFileRefServiceImpl
implements PrdFsmFileRefService {
    private static final Logger log = LoggerFactory.getLogger(PrdFsmFileRefServiceImpl.class);
    private final PrdFsmFileRefRepo repo;
    private final FileUtil fileUtil;
    private final FileService fileService;

    @Transactional(rollbackFor={Exception.class})
    public PrdFsmFileRefVO insert(PrdFsmFileRefPayload payload) {
        this.check(payload);
        if (StringUtils.hasText((String)payload.getFileCode())) {
            PrdFsmFileRefDO entityDo = PrdFsmFileRefConvert.INSTANCE.toDo(payload);
            this.repo.save((Object)entityDo);
            return PrdFsmFileRefConvert.INSTANCE.toVo(entityDo);
        }
        return PrdFsmFileRefConvert.INSTANCE.payloadToVo(payload);
    }

    private void check(PrdFsmFileRefPayload payload) {
        if (!StringUtils.hasText((String)payload.getObjType())) {
            throw TwException.error("", "objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == payload.getObjId()) {
            throw TwException.error("", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdFsmFileRefVO update(PrdFsmFileRefPayload payload) {
        PrdFsmFileRefDO entity = this.repo.findById(payload.getId()).orElseGet(PrdFsmFileRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdFsmFileRefDO entityDo = PrdFsmFileRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdFsmFileRefDO save = (PrdFsmFileRefDO)((Object)this.repo.save((Object)entity));
        return PrdFsmFileRefConvert.INSTANCE.toVo(save);
    }

    public PrdFsmFileRefVO queryByKey(Long key) {
        PrdFsmFileRefDO entity = this.repo.findById(key).orElseGet(PrdFsmFileRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdFsmFileRefVO crmCustomerOperationVO = PrdFsmFileRefConvert.INSTANCE.toVo(entity);
        crmCustomerOperationVO.setFileData(this.fileUtil.getFileDatas(crmCustomerOperationVO.getFileCode()));
        return crmCustomerOperationVO;
    }

    public List<PrdFsmFileRefVO> queryList(PrdFsmFileRefQuery query) {
        this.checkQuery(query);
        List listDO = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        List<PrdFsmFileRefVO> list = PrdFsmFileRefConvert.INSTANCE.toVoList(listDO);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<FileObjRespVO<T>>> fileDataMap = this.fileUtil.getFileDataMap(list);
            list.forEach(prdFsmFileRefVO -> prdFsmFileRefVO.setFileData(fileDataMap.get(prdFsmFileRefVO.getFileCode())));
        }
        return list;
    }

    public long count(PrdFsmFileRefQuery query) {
        this.checkQuery(query);
        return this.repo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public long count(String objTypeEnum, Long objId) {
        PrdFsmFileRefQuery query = new PrdFsmFileRefQuery();
        query.setObjType(objTypeEnum);
        query.setObjId(objId);
        return this.count(query);
    }

    public PagingVO<PrdFsmFileRefVO> paging(PrdFsmFileRefQuery query) {
        this.checkQuery(query);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        Page fsmFileRefVOPage = page.map(PrdFsmFileRefConvert.INSTANCE::toVo);
        List list = fsmFileRefVOPage.getContent();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, List<FileObjRespVO<T>>> fileDataMap = this.fileUtil.getFileDataMap(list);
            list.forEach(prdFsmFileRefVO -> prdFsmFileRefVO.setFileData(fileDataMap.get(prdFsmFileRefVO.getFileCode())));
        }
        return PageUtil.toPageVo(fsmFileRefVOPage);
    }

    private void checkQuery(PrdFsmFileRefQuery query) {
        if (!StringUtils.hasText((String)query.getObjType())) {
            throw TwException.error("", "objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == query.getObjId()) {
            throw TwException.error("", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            ArrayList fileCodes = new ArrayList();
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    PrdFsmFileRefDO entity = (PrdFsmFileRefDO)((Object)((Object)optional.get()));
                    fileCodes.add(entity.getFileCode());
                    entity.setDeleteFlag(1);
                    this.repo.save((Object)entity);
                }
            });
            this.fileService.delete(fileCodes);
        }
    }

    public void deleteSoftByFileCode(String fileCode) {
        if (StringUtils.hasText((String)fileCode)) {
            ArrayList<String> fileCodes = new ArrayList<String>();
            Optional<PrdFsmFileRefDO> optional = this.repo.findByFileCode(fileCode);
            if (!optional.isEmpty()) {
                PrdFsmFileRefDO entity = optional.get();
                fileCodes.add(entity.getFileCode());
                entity.setDeleteFlag(1);
                this.repo.save((Object)entity);
            }
            this.fileService.delete(fileCodes);
        }
    }

    public void deleteSoftByObjIdAndObjType(Long objId, String objType) {
        List<PrdFsmFileRefDO> list = this.repo.findByObjIdAndObjType(objId, objType);
        list.forEach(prdFsmFileRefDO -> prdFsmFileRefDO.setDeleteFlag(1));
        this.repo.saveAll(list);
    }

    public PrdFsmFileRefServiceImpl(PrdFsmFileRefRepo repo, FileUtil fileUtil, FileService fileService) {
        this.repo = repo;
        this.fileUtil = fileUtil;
        this.fileService = fileService;
    }
}

